/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.extension.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;

public class CapellaMetamodelHelper {
    public static boolean hasCapellaGenClasses(GenPackage genPackage) {
        for (GenClass genClass : genPackage.getGenClasses()) {
            if (!CapellaMetamodelHelper.isCapellaGenClass(genClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCapellaGenClasses(GenModel genModel) {
        for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
            if (!CapellaMetamodelHelper.hasCapellaGenClasses(genPackage)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCapellaGenClass(GenClass genClass) {
        EClass ecoreClass = genClass.getEcoreClass();
        EClass modelElement = ModellingcorePackage.eINSTANCE.getModelElement();
        return CapellaMetamodelHelper.contains((List<EClass>)ecoreClass.getEAllSuperTypes(), modelElement);
    }

    public static List<GenClass> getCapellaGenClasses(EList<GenClass> allGenClasses) {
        ArrayList<GenClass> result = new ArrayList<GenClass>(allGenClasses.size());
        for (GenClass gen : allGenClasses) {
            if (!CapellaMetamodelHelper.isCapellaGenClass(gen)) continue;
            result.add(gen);
        }
        return result;
    }

    private static boolean contains(List<EClass> classes, EClass source) {
        String name = source.getName();
        String nsURI = source.getEPackage().getNsURI();
        for (EClass cls : classes) {
            if (!cls.getName().equals(name) || !nsURI.equals(cls.getEPackage().getNsURI())) continue;
            return true;
        }
        return false;
    }

    private CapellaMetamodelHelper() {
    }
}

