/*******************************************************************************
 * Copyright (c) 2017, 2020 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.RelationshipHelper;

public class CapabilityExploitationHelper {
	private static CapabilityExploitationHelper instance;

	private CapabilityExploitationHelper() {
    // do nothing
	}

	public static CapabilityExploitationHelper getInstance() {
		if (instance == null)
			instance = new CapabilityExploitationHelper();
		return instance;
	}

	public Object doSwitch(CapabilityExploitation element, EStructuralFeature feature) {
		Object ret = null;

		if (feature.equals(CtxPackage.Literals.CAPABILITY_EXPLOITATION__MISSION)) {
			ret = getMission(element);
		}
		// no helper found... searching in super classes...
		if(null == ret) {
			ret = RelationshipHelper.getInstance().doSwitch(element, feature);
		}

		return ret;
	}

  private Mission getMission(CapabilityExploitation element) {
    EObject parent = element.eContainer();
    if (parent instanceof Mission) {
      return (Mission)parent;
    }
    return null;
  }

}
