/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.client.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.net.SessionConnectionBase;
import org.eclipse.scada.hd.ItemListListener;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.client.Connection;
import org.eclipse.scada.hd.client.net.DriverFactoryImpl;
import org.eclipse.scada.hd.client.net.ErrorQueryImpl;
import org.eclipse.scada.hd.client.net.QueryImpl;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.net.ItemListHelper;
import org.eclipse.scada.hd.net.QueryHelper;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends SessionConnectionBase
implements Connection {
    protected final Random random = new Random();
    public static final String VERSION = "0.1.0";
    private static final Logger logger;
    private static final int MAX_QUERY_ENTRIES;
    private final Set<ItemListListener> itemListListeners = new HashSet<ItemListListener>();
    private final Map<Long, QueryImpl> queries = new HashMap<Long, QueryImpl>();
    protected Map<String, HistoricalItemInformation> knownItems = new HashMap<String, HistoricalItemInformation>();
    private static final Object STATS_COUNT_QUERIES;

    static {
        DriverFactoryImpl.registerDriver();
        logger = LoggerFactory.getLogger(ConnectionImpl.class);
        MAX_QUERY_ENTRIES = Integer.getInteger("org.eclipse.scada.hd.client.net.maxQuerySize", 4096);
        STATS_COUNT_QUERIES = new Object();
    }

    public String getRequiredVersion() {
        return VERSION;
    }

    public ConnectionImpl(ConnectionInformation connectionInformantion) {
        super(connectionInformantion);
        this.statistics.setLabel(STATS_COUNT_QUERIES, "Active queries");
        this.init();
    }

    protected void init() {
        this.messenger.setHandler(262163, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleListUpdate(message);
            }
        });
        this.messenger.setHandler(262149, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleQueryDataUpdate(message);
            }
        });
        this.messenger.setHandler(262148, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleQueryStatusUpdate(message);
            }
        });
        this.messenger.setHandler(262150, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ConnectionImpl.this.handleQueryParameterUpdate(message);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleQueryParameterUpdate(Message message) {
        Long queryId = ((LongValue)message.getValues().get("id")).getValue();
        QueryParameters parameters = QueryHelper.fromValue((Value)message.getValues().get("parameters"));
        Set valueTypes = QueryHelper.fromValueTypes((Value)message.getValues().get("valueTypes"));
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            QueryImpl query = this.queries.get(queryId);
            if (query != null) {
                query.handleUpdateParameter(parameters, valueTypes);
            } else {
                logger.warn("Status update for missing query: {}", (Object)queryId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleQueryStatusUpdate(Message message) {
        Long queryId = ((LongValue)message.getValues().get("id")).getValue();
        String state = ((StringValue)message.getValues().get("state")).getValue();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            QueryImpl query = this.queries.get(queryId);
            if (query != null) {
                query.handleUpdateStatus(QueryState.valueOf((String)state));
            } else {
                logger.warn("Status update for missing query: {}", (Object)queryId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleQueryDataUpdate(Message message) {
        Long queryId = ((LongValue)message.getValues().get("id")).getValue();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            QueryImpl query = this.queries.get(queryId);
            if (query != null) {
                int index = ((IntegerValue)message.getValues().get("index")).getValue();
                Map values = QueryHelper.fromValueData((Value)message.getValues().get("values"));
                List valueInformation = QueryHelper.fromValueInfo((Value)message.getValues().get("valueInformation"));
                if (index >= 0 && values != null && valueInformation != null) {
                    query.handleUpdateData(index, values, valueInformation);
                }
            } else {
                logger.warn("Data update for missing query: {}", (Object)queryId);
            }
        }
    }

    protected synchronized void handleListUpdate(Message message) {
        Set addedOrModified = ItemListHelper.fromValue((Value)message.getValues().get("added"));
        Set removed = ItemListHelper.fromValueRemoved((Value)message.getValues().get("removed"));
        boolean full = message.getValues().containsKey("full");
        this.fireListChanged(addedOrModified, removed, full);
    }

    private synchronized void fireListChanged(final Set<HistoricalItemInformation> addedOrModified, final Set<String> removed, final boolean full) {
        this.applyChange(addedOrModified, removed, full);
        final ArrayList<ItemListListener> listeners = new ArrayList<ItemListListener>(this.itemListListeners);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (ItemListListener listener : listeners) {
                    listener.listChanged(addedOrModified, removed, full);
                }
            }
        });
    }

    private void applyChange(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean full) {
        if (full) {
            this.knownItems.clear();
        }
        if (removed != null) {
            for (String string : removed) {
                this.knownItems.remove(string);
            }
        }
        if (addedOrModified != null) {
            for (HistoricalItemInformation historicalItemInformation : addedOrModified) {
                this.knownItems.put(historicalItemInformation.getItemId(), historicalItemInformation);
            }
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    protected synchronized void switchState(ConnectionState state, Throwable error, Map<String, String> properties) {
        super.switchState(state, error, properties);
        switch (state) {
            case BOUND: {
                this.sendRequestItemList(!this.itemListListeners.isEmpty());
                break;
            }
            case CLOSED: {
                this.fireListChanged(new HashSet<HistoricalItemInformation>(), null, true);
                ArrayList<QueryImpl> queries = new ArrayList<QueryImpl>(this.queries.values());
                for (QueryImpl query : queries) {
                    query.close();
                }
                this.queries.clear();
                break;
            }
        }
    }

    public synchronized void addListListener(final ItemListListener listener) {
        boolean isEmpty = this.itemListListeners.isEmpty();
        this.itemListListeners.add(listener);
        if (isEmpty != this.itemListListeners.isEmpty()) {
            this.sendRequestItemList(true);
        }
        final HashSet<HistoricalItemInformation> currentItems = new HashSet<HistoricalItemInformation>(this.knownItems.values());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.listChanged((Set)currentItems, null, true);
            }
        });
    }

    public synchronized void removeListListener(ItemListListener listener) {
        boolean isEmpty = this.itemListListeners.isEmpty();
        this.itemListListeners.remove(listener);
        if (isEmpty != this.itemListListeners.isEmpty()) {
            this.sendRequestItemList(false);
        }
    }

    private void sendRequestItemList(boolean flag) {
        logger.info("Request item list: {}", (Object)flag);
        this.messenger.sendMessage(ItemListHelper.createRequestList((boolean)flag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String itemId, QueryParameters parameters, QueryListener listener, boolean updateData) {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.getState() == ConnectionState.BOUND) {
                QueryImpl query = new QueryImpl(this.executor, this, itemId, parameters, listener);
                Long id = this.random.nextLong();
                while (this.queries.containsKey(id)) {
                    id = this.random.nextLong();
                }
                query.setId(id);
                this.queries.put(id, query);
                this.statistics.setCurrentValue(STATS_COUNT_QUERIES, (double)this.queries.size());
                this.sendCreateQuery(id, itemId, parameters, updateData);
                return query;
            }
            return new ErrorQueryImpl(listener);
        }
    }

    protected void sendCreateQuery(long id, String itemId, QueryParameters parameters, boolean updateData) {
        Message message = new Message(262145);
        message.getValues().put("itemId", (Value)new StringValue(itemId));
        message.getValues().put("id", (Value)new LongValue(id));
        message.getValues().put("parameters", QueryHelper.toValue((QueryParameters)this.checkParameters(parameters)));
        if (updateData) {
            message.getValues().put("updateData", (Value)VoidValue.INSTANCE);
        }
        this.messenger.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQueryParameters(QueryImpl queryImpl, QueryParameters parameters) {
        Long id = queryImpl.getId();
        if (id == null) {
            return;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.queries.get(id) != queryImpl) {
                return;
            }
            this.sendUpdateQueryParameters(id, parameters);
        }
    }

    private void sendUpdateQueryParameters(Long id, QueryParameters parameters) {
        Message message = new Message(262147);
        message.getValues().put("id", (Value)new LongValue(id.longValue()));
        message.getValues().put("parameters", QueryHelper.toValue((QueryParameters)this.checkParameters(parameters)));
        this.messenger.sendMessage(message);
    }

    private QueryParameters checkParameters(QueryParameters parameters) {
        return new QueryParameters(parameters.getStartTimestamp(), parameters.getEndTimestamp(), Math.min(parameters.getNumberOfEntries(), MAX_QUERY_ENTRIES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeQuery(QueryImpl queryImpl) {
        Long id = queryImpl.getCloseId();
        logger.debug("Request to close query: {}", (Object)id);
        if (id == null) {
            return;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            QueryImpl query = this.queries.remove(id);
            logger.debug("Removed query: {}", (Object)query);
            this.statistics.setCurrentValue(STATS_COUNT_QUERIES, (double)this.queries.size());
            this.performCloseQuery(id, query);
        }
    }

    private void performCloseQuery(Long id, QueryImpl query) {
        query.setId(null);
        this.sendCloseQuery(id);
    }

    private void sendCloseQuery(Long id) {
        Message message = new Message(262146);
        message.getValues().put("id", (Value)new LongValue(id.longValue()));
        this.messenger.sendMessage(message);
    }
}

