/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Helper {
    public static double niceNum(double value, boolean round) {
        int exp = (int)Math.floor(Math.log10(value));
        double f = value / Math.pow(10.0, exp);
        double nf = round ? (f < 1.5 ? 1.0 : (f < 3.0 ? 2.0 : (f < 7.0 ? 5.0 : 10.0))) : (f <= 1.0 ? 1.0 : (f <= 2.0 ? 2.0 : (f <= 5.0 ? 5.0 : 10.0)));
        return nf * Math.pow(10.0, exp);
    }

    public static List<Entry<Double>> chartValues(double min, double max, int pixels, int labelHeight) {
        int nticks = pixels / labelHeight;
        if (nticks <= 1) {
            return Collections.emptyList();
        }
        double range = Helper.niceNum(max - min, false);
        double d = Helper.niceNum(range / (double)(nticks - 1), true);
        double graphmin = Math.floor(min / d) * d;
        double graphmax = Math.ceil(max / d) * d;
        int nfrac = Math.max(-((int)Math.floor(Math.log10(d))), 0);
        LinkedList<Entry<Double>> result = new LinkedList<Entry<Double>>();
        double x = graphmin;
        while (x <= graphmax + 0.5 * d) {
            int position = (int)((double)pixels - (double)pixels / (max - min) * (x - min));
            try {
                result.add(new Entry<Double>(String.format("%." + nfrac + "f", x), x, position));
            }
            catch (Exception exception) {
                result.add(new Entry<Double>(String.format("%f", x), x, position));
            }
            x += d;
        }
        return result;
    }

    public static long niceTimeRounded(long value) {
        TimeUnit tu = value >= TimeUnit.DAYS.toMillis(1L) ? TimeUnit.DAYS : (value >= TimeUnit.HOURS.toMillis(1L) ? TimeUnit.HOURS : (value >= TimeUnit.MINUTES.toMillis(1L) ? TimeUnit.MINUTES : (value >= TimeUnit.SECONDS.toMillis(1L) ? TimeUnit.SECONDS : TimeUnit.MILLISECONDS)));
        double v = (double)value / (double)tu.toMillis(1L);
        v = Helper.niceNum(v, true);
        return (long)(v * (double)tu.toMillis(1L));
    }

    public static List<Entry<Long>> chartTimes(long min, long max, int pixels, int labelWidth, DateFormat format) {
        int nticks = pixels / labelWidth;
        if (nticks <= 1) {
            return Collections.emptyList();
        }
        long range = (long)Helper.niceNum(max - min, false);
        long step = Helper.niceTimeRounded(range / (long)(nticks - 1));
        long graphmin = (long)(Math.floor(min / step) * (double)step);
        long graphmax = (long)(Math.ceil(max / step) * (double)step);
        LinkedList<Entry<Long>> result = new LinkedList<Entry<Long>>();
        long x = graphmin;
        while ((double)x <= (double)graphmax + 0.5 * (double)step) {
            int position = (int)((double)pixels / (double)(max - min) * (double)(x - min));
            try {
                result.add(new Entry<Long>(format.format(new Date(x)), x, position));
            }
            catch (Exception exception) {
                result.add(new Entry<Long>(new Date(x).toString(), x, position));
            }
            x += step;
        }
        return result;
    }

    public static DateFormat makeFormat(long range) {
        if (range <= 1000L) {
            return new SimpleDateFormat("ss.SSS");
        }
        if (range <= 60000L) {
            return new SimpleDateFormat("mm:ss.SSS");
        }
        if (range <= 3600000L) {
            return new SimpleDateFormat("HH:mm:ss");
        }
        if (range <= 86400000L) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm");
    }

    public static class Entry<T> {
        public String label;
        public T value;
        public int position;

        public Entry(String label, T value, int position) {
            this.label = label;
            this.value = value;
            this.position = position;
        }

        public String toString() {
            return String.format("%s - %s - %s", this.label, this.value, this.position);
        }
    }
}

