/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart;

import org.eclipse.scada.utils.beans.AbstractPropertyChange;

public class YAxis
extends AbstractPropertyChange {
    public static final String PROP_MIN = "min";
    public static final String PROP_MAX = "max";
    public static final String PROP_LABEL = "label";
    private double min;
    private double max;
    private String label;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.firePropertyChange(PROP_LABEL, this.label, this.label);
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
        this.firePropertyChange(PROP_MIN, this.min, this.min);
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.firePropertyChange(PROP_MAX, this.max, this.max);
    }

    public void setMinMax(double min, double max) {
        if (min >= max) {
            return;
        }
        this.setMin(min);
        this.setMax(max);
    }

    public void zoom(double factor) {
        double diff = (this.max - this.min) * factor;
        if (factor > 1.0) {
            this.setMinMax(this.min - diff, this.max + diff);
        } else {
            this.setMinMax(this.min + diff, this.max - diff);
        }
    }

    public void transform(double offset, int clientHeight) {
        double diff = this.max - this.min;
        double factor = diff / (double)clientHeight;
        double clientOffset = offset * factor;
        this.setMinMax(this.min - clientOffset, this.max - clientOffset);
    }

    public float translateToClient(int height, double value) {
        double diffY = this.max - this.min;
        double factorY = (double)height / diffY;
        return (float)((double)height - factorY * (value - this.min));
    }

    public double translateToValue(int height, float position) {
        double pos = 1.0 - (double)(position / (float)height);
        double diffX = this.max - this.min;
        return diffX * pos + this.min;
    }
}

