/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.utils;

import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.statuscodes.CodedExceptionBase;
import org.eclipse.scada.utils.statuscodes.StatusCode;

public class MessageCreator {
    public static Message createUnknownMessage(Message inputMessage) {
        Message msg = new Message(1);
        msg.setReplySequence(inputMessage.getSequence());
        return msg;
    }

    public static Message createFailedMessage(Message inputMessage, Throwable error) {
        String msg = null;
        Throwable root = ExceptionHelper.getRootCause((Throwable)error);
        if (root instanceof CodedExceptionBase) {
            StatusCode status = ((CodedExceptionBase)root).getStatus();
            if (status != null) {
                msg = status.toString();
            }
        } else {
            msg = ExceptionHelper.getMessage((Throwable)error);
        }
        if (msg == null) {
            msg = error.toString();
        }
        return MessageCreator.createFailedMessage(inputMessage, msg);
    }

    public static Message createFailedMessage(Message inputMessage, String failMessage) {
        return MessageCreator.createFailedMessage(inputMessage, 2, failMessage);
    }

    public static Message createFailedMessage(Message inputMessage, int commandCode, String failMessage) {
        Message msg = new Message(commandCode);
        msg.setReplySequence(inputMessage.getSequence());
        msg.setValue("error-info", failMessage);
        return msg;
    }

    public static Message createPing() {
        Message msg = new Message(16);
        msg.getValues().put("ping-data", new StringValue(String.valueOf(System.currentTimeMillis())));
        return msg;
    }

    public static Message createPong(Message inputMessage) {
        Message msg = new Message(17, inputMessage.getSequence());
        msg.getValues().put("pong-data", inputMessage.getValues().get("ping-data"));
        return msg;
    }

    public static Message createACK(Message inputMessage) {
        return new Message(3, inputMessage.getSequence());
    }
}

