/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.filter;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.scada.utils.filter.Assertion;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterAssertion;
import org.eclipse.scada.utils.filter.FilterEmpty;
import org.eclipse.scada.utils.filter.FilterExpression;
import org.eclipse.scada.utils.filter.FilterParseException;
import org.eclipse.scada.utils.filter.Messages;
import org.eclipse.scada.utils.filter.Operator;
import org.eclipse.scada.utils.filter.internal.Encoder;
import org.eclipse.scada.utils.filter.internal.Tokenizer;
import org.eclipse.scada.utils.filter.internal.Tokens;

public class FilterParser {
    private final Filter filter;

    public FilterParser(String filter) throws FilterParseException {
        if (filter == null || "".equals(filter.trim())) {
            this.filter = new FilterEmpty();
            return;
        }
        boolean expressionExpected = true;
        FilterAssertion currentAssertion = null;
        Stack<FilterExpression> filterExpressions = new Stack<FilterExpression>();
        Object result = null;
        try {
            for (Tokens.Token token : new Tokenizer(filter)) {
                if (token instanceof Tokens.TokenLeftParen) {
                    expressionExpected = false;
                    continue;
                }
                if (token instanceof Tokens.TokenOperator) {
                    expressionExpected = true;
                    FilterExpression expression = new FilterExpression();
                    if ("|".equals(token.getValue())) {
                        expression.setOperator(Operator.OR);
                    } else if ("&".equals(token.getValue())) {
                        expression.setOperator(Operator.AND);
                    } else if ("!".equals(token.getValue())) {
                        expression.setOperator(Operator.NOT);
                    }
                    if (filterExpressions.isEmpty()) {
                        result = expression;
                    } else {
                        ((FilterExpression)filterExpressions.peek()).getFilterSet().add(expression);
                    }
                    filterExpressions.push(expression);
                    continue;
                }
                if (expressionExpected) {
                    throw new FilterParseException(Messages.getString("FilterParser.Error.ExpressionExpected"));
                }
                if (token instanceof Tokens.TokenAttribute) {
                    currentAssertion = new FilterAssertion(token.getValue(), null, "");
                    continue;
                }
                if (token instanceof Tokens.TokenAssertion) {
                    if ("=".equals(token.getValue())) {
                        currentAssertion.setAssertion(Assertion.EQUALITY);
                        continue;
                    }
                    if (">=".equals(token.getValue())) {
                        currentAssertion.setAssertion(Assertion.GREATEREQ);
                        continue;
                    }
                    if (">".equals(token.getValue())) {
                        currentAssertion.setAssertion(Assertion.GREATERTHAN);
                        continue;
                    }
                    if ("<=".equals(token.getValue())) {
                        currentAssertion.setAssertion(Assertion.LESSEQ);
                        continue;
                    }
                    if ("<".equals(token.getValue())) {
                        currentAssertion.setAssertion(Assertion.LESSTHAN);
                        continue;
                    }
                    if ("~=".equals(token.getValue())) {
                        currentAssertion.setAssertion(Assertion.APPROXIMATE);
                        continue;
                    }
                    if (!"=*".equals(token.getValue())) continue;
                    currentAssertion.setAssertion(Assertion.PRESENCE);
                    continue;
                }
                if (token instanceof Tokens.TokenValue) {
                    currentAssertion.setValue(this.toValue(currentAssertion, token.getValue()));
                    continue;
                }
                if (!(token instanceof Tokens.TokenRightParen)) continue;
                if (result == null) {
                    this.validate(currentAssertion);
                    result = currentAssertion;
                    break;
                }
                if (currentAssertion != null) {
                    this.validate(currentAssertion);
                    ((FilterExpression)filterExpressions.peek()).getFilterSet().add(currentAssertion);
                    currentAssertion = null;
                    continue;
                }
                try {
                    this.validate((Filter)filterExpressions.pop());
                }
                catch (EmptyStackException emptyStackException) {
                    throw new FilterParseException(Messages.getString("FilterParser.Error.ExpressionExpected"));
                }
            }
        }
        catch (Tokenizer.TokenizeException e) {
            throw new FilterParseException(e.getMessage());
        }
        this.validate((Filter)result);
        if (!result.toString().equals(filter)) {
            throw new FilterParseException(String.format(Messages.getString("FilterParser.Error.ExpressionAmbiguous"), result.toString()));
        }
        this.filter = result;
    }

    private void validate(Filter toValidate) {
        if (toValidate == null) {
            throw new FilterParseException(Messages.getString("FilterParser.Error.NoFilterGiven"));
        }
        if (toValidate.isAssertion()) {
            FilterAssertion assertion = (FilterAssertion)toValidate;
            if (assertion.getAttribute() == null) {
                throw new FilterParseException(Messages.getString("FilterParser.Error.NoAttributeGiven"));
            }
            if (assertion.getAssertion() == null) {
                throw new FilterParseException(Messages.getString("FilterParser.Error.NoAssertionGiven"));
            }
            if (assertion.getValue() == null) {
                throw new FilterParseException(Messages.getString("FilterParser.Error.NoValueGiven"));
            }
        } else if (toValidate.isExpression()) {
            FilterExpression expression = (FilterExpression)toValidate;
            if (expression.getOperator() == null) {
                throw new FilterParseException(Messages.getString("FilterParser.Error.NoOperatorGiven"));
            }
            if (expression.getFilterSet().size() == 0) {
                throw new FilterParseException(Messages.getString("FilterParser.Error.MissingSubExpression"));
            }
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    private Object toValue(FilterAssertion currentAssertion, String value) throws Tokenizer.TokenizeException {
        if (currentAssertion.getAssertion() == Assertion.EQUALITY && value.contains("*")) {
            currentAssertion.setAssertion(Assertion.SUBSTRING);
            ArrayList<String> result = new ArrayList<String>();
            String[] stringArray = value.split("\\*");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                result.add(Encoder.decode(part));
                ++n2;
            }
            if (value.charAt(value.length() - 1) == '*') {
                result.add("");
            }
            return result;
        }
        return Encoder.decode(value);
    }
}

