/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets.control;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.widgets.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrendControlImage
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(TrendControlImage.class);
    private final String connectionId;
    private final String itemId;
    private final String queryString;

    public TrendControlImage(Composite parent, int style, String connectionId, String itemId, String queryString) {
        super(parent, style);
        this.connectionId = connectionId;
        this.itemId = itemId;
        this.queryString = queryString;
        this.setLayout((Layout)new FillLayout());
        Button button = new Button(parent, 0x800008);
        button.setImage(Activator.getDefault().getImageRegistry().get("trend"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrendControlImage.this.startHdView();
            }
        });
    }

    protected void startHdView() {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            Command command = commandService.getCommand("org.eclipse.scada.ui.chart.view.commands.OpenParametersChartView");
            Parameterization[] parameterizations = new Parameterization[]{new Parameterization(command.getParameter("org.eclipse.scada.ui.chart.connectionId"), this.connectionId), new Parameterization(command.getParameter("org.eclipse.scada.ui.chart.itemId"), this.itemId), this.queryString == null || this.queryString.isEmpty() ? new Parameterization(command.getParameter("org.eclipse.scada.ui.chart.queryTimespec"), "2400000:600000") : new Parameterization(command.getParameter("org.eclipse.scada.ui.chart.queryTimespec"), this.queryString), new Parameterization(command.getParameter("org.eclipse.scada.ui.chart.itemType"), "hd")};
            ParameterizedCommand parameterCommand = new ParameterizedCommand(command, parameterizations);
            handlerService.executeCommand(parameterCommand, null);
        }
        catch (Exception e) {
            logger.debug("Failed to open view", (Throwable)e);
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.scada.vi.details.swt", Messages.TrendControlImage_TrendError, (Throwable)e), 4);
        }
    }
}

