/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.pool;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.utils.osgi.pool.ObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectPoolServiceTracker<S> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObjectPoolServiceTracker.class);
    private final ObjectPoolTracker<S> poolTracker;
    private final ObjectPoolTracker.ObjectPoolServiceListener<S> poolListener;
    protected final String serviceId;
    private final Map<ObjectPool<S>, PoolHandler> poolMap = new HashMap<ObjectPool<S>, PoolHandler>(1);

    public AbstractObjectPoolServiceTracker(ObjectPoolTracker<S> poolTracker, String serviceId) {
        this.serviceId = serviceId;
        this.poolTracker = poolTracker;
        this.poolListener = new ObjectPoolTracker.ObjectPoolServiceListener<S>(){

            @Override
            public void poolRemoved(ObjectPool<S> objectPool) {
                AbstractObjectPoolServiceTracker.this.handlePoolRemove(objectPool);
            }

            @Override
            public void poolModified(ObjectPool<S> objectPool, int newPriority) {
                AbstractObjectPoolServiceTracker.this.handlePoolModified(objectPool, newPriority);
            }

            @Override
            public void poolAdded(ObjectPool<S> objectPool, int priority) {
                AbstractObjectPoolServiceTracker.this.handlePoolAdd(objectPool, priority);
            }
        };
    }

    protected abstract void handleServiceAdded(S var1, Dictionary<?, ?> var2);

    protected abstract void handleServiceModified(S var1, Dictionary<?, ?> var2);

    protected abstract void handleServiceRemoved(S var1, Dictionary<?, ?> var2);

    protected synchronized void handlePoolAdd(ObjectPool<S> objectPool, int priority) {
        logger.debug("Pool added: {}/{}", objectPool, (Object)priority);
        this.poolMap.put(objectPool, new PoolHandler(objectPool, this.serviceId));
    }

    protected synchronized void handlePoolModified(ObjectPool<S> objectPool, int newPriority) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePoolRemove(ObjectPool<S> objectPool) {
        PoolHandler handler;
        AbstractObjectPoolServiceTracker abstractObjectPoolServiceTracker = this;
        synchronized (abstractObjectPoolServiceTracker) {
            logger.debug("Pool removed: {}", objectPool);
            handler = this.poolMap.get(objectPool);
        }
        if (handler != null) {
            handler.dispose();
        }
    }

    public void open() {
        this.poolTracker.addListener(this.poolListener);
    }

    public void close() {
        this.poolTracker.removeListener(this.poolListener);
    }

    protected class PoolHandler
    implements ObjectPoolListener<S> {
        private final ObjectPool<S> pool;
        private final String serviceId;
        private final Map<S, Dictionary<?, ?>> services = new HashMap(1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PoolHandler(ObjectPool<S> pool, String serviceId) {
            this.pool = pool;
            this.serviceId = serviceId;
            PoolHandler poolHandler = this;
            synchronized (poolHandler) {
                this.pool.addListener(this.serviceId, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void dispose() {
            HashMap services;
            PoolHandler poolHandler = this;
            synchronized (poolHandler) {
                this.pool.removeListener(this.serviceId, this);
                services = new HashMap(this.services);
                this.services.clear();
            }
            for (Map.Entry entry : services.entrySet()) {
                this.fireServiceRemoved(entry.getKey(), (Dictionary)entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceAdded(S service, Dictionary<?, ?> properties) {
            PoolHandler poolHandler = this;
            synchronized (poolHandler) {
                this.services.put(service, properties);
            }
            this.fireServiceAdded(service, properties);
        }

        private void fireServiceAdded(S service, Dictionary<?, ?> properties) {
            logger.debug("Service added to pool: {} -> {}", new Object[]{this.serviceId, service});
            AbstractObjectPoolServiceTracker.this.handleServiceAdded(service, properties);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceModified(S service, Dictionary<?, ?> properties) {
            PoolHandler poolHandler = this;
            synchronized (poolHandler) {
                this.services.put(service, properties);
            }
            this.fireServiceModified(service, properties);
        }

        private void fireServiceModified(S service, Dictionary<?, ?> properties) {
            AbstractObjectPoolServiceTracker.this.handleServiceModified(service, properties);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceRemoved(S service, Dictionary<?, ?> properties) {
            Dictionary<?, ?> oldProperties;
            PoolHandler poolHandler = this;
            synchronized (poolHandler) {
                oldProperties = this.services.remove(service);
            }
            if (oldProperties != null) {
                this.fireServiceRemoved(service, properties);
            }
        }

        private void fireServiceRemoved(S service, Dictionary<?, ?> properties) {
            AbstractObjectPoolServiceTracker.this.handleServiceRemoved(service, properties);
        }
    }
}

