/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.pool;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.utils.osgi.pool.AbstractObjectPoolServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleObjectPoolServiceTracker<S>
extends AbstractObjectPoolServiceTracker<S> {
    private static final Logger logger = LoggerFactory.getLogger(SingleObjectPoolServiceTracker.class);
    private static final int DEFAULT_PRIORITY = 0;
    private final ServiceListener<S> listener;
    private final Map<S, Dictionary<?, ?>> services = new HashMap();
    private volatile S currentService;

    public SingleObjectPoolServiceTracker(ObjectPoolTracker<S> poolTracker, String serviceId, ServiceListener<S> listener) {
        super(poolTracker, serviceId);
        this.listener = listener;
    }

    protected int getPriority(Dictionary<?, ?> properties) {
        return this.getPriority(properties, 0);
    }

    protected int getPriority(Dictionary<?, ?> properties, int defaultPriority) {
        Object o = properties.get("service.ranking");
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return defaultPriority;
    }

    @Override
    protected synchronized void handleServiceAdded(S service, Dictionary<?, ?> properties) {
        this.services.put(service, properties);
        this.update();
    }

    @Override
    protected synchronized void handleServiceModified(S service, Dictionary<?, ?> properties) {
        this.services.put(service, properties);
        this.update();
    }

    @Override
    protected synchronized void handleServiceRemoved(S service, Dictionary<?, ?> properties) {
        this.services.remove(service);
        this.update();
    }

    protected void update() {
        S bestService = null;
        Dictionary<?, ?> bestProperties = null;
        for (Map.Entry<S, Dictionary<?, ?>> entry : this.services.entrySet()) {
            int priority = this.getPriority(entry.getValue());
            if (priority <= Integer.MIN_VALUE) continue;
            bestService = entry.getKey();
            bestProperties = entry.getValue();
        }
        this.setService(bestService, bestProperties);
    }

    private synchronized void setService(S bestService, Dictionary<?, ?> bestProperties) {
        if (this.currentService != bestService) {
            logger.debug("Change service: {} -> {}", new Object[]{this.currentService, bestService});
            this.currentService = bestService;
            this.fireServiceChange(bestService, bestProperties);
        }
    }

    private void fireServiceChange(S bestService, Dictionary<?, ?> bestProperties) {
        if (this.listener != null) {
            this.listener.serviceChange(bestService, bestProperties);
        }
    }

    public S getCurrentService() {
        return this.currentService;
    }

    public static interface ServiceListener<S> {
        public void serviceChange(S var1, Dictionary<?, ?> var2);
    }
}

