/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.connection.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.DriverFactory;
import org.eclipse.scada.core.connection.provider.AbstractConnectionService;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionManager
implements SingleServiceListener<DriverFactory> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionManager.class);
    private final ConnectionInformation connectionInformation;
    private final BundleContext context;
    private final String connectionId;
    private SingleServiceTracker<DriverFactory> tracker;
    private AbstractConnectionService connection;
    private ServiceRegistration<?> serviceReg;
    private DriverFactory factory;
    private final Integer autoReconnectDelay;
    private final boolean initialOpen;
    private final Set<ConnectionRequest> requests = new HashSet<ConnectionRequest>();

    public AbstractConnectionManager(BundleContext context, ConnectionInformation connectionInformation, String connectionId, Integer autoReconnectDelay, boolean initialOpen) {
        Filter filter;
        this.context = context;
        this.connectionInformation = connectionInformation;
        this.connectionId = connectionId;
        this.autoReconnectDelay = autoReconnectDelay;
        this.initialOpen = initialOpen;
        String interfaceName = this.connectionInformation.getInterface();
        String driverName = this.connectionInformation.getDriver();
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("interface", interfaceName);
            parameters.put("driver", driverName);
            filter = FilterUtil.createAndFilter((String)DriverFactory.class.getName(), parameters);
            logger.debug("Created filter: {}", (Object)filter);
        }
        catch (InvalidSyntaxException e) {
            filter = null;
            logger.warn("Failed to create filter", (Throwable)e);
        }
        if (filter != null) {
            this.tracker = new SingleServiceTracker(this.context, filter, (SingleServiceListener)this);
            this.tracker.open();
        } else {
            this.tracker = null;
        }
    }

    public Integer getAutoReconnectDelay() {
        return this.autoReconnectDelay;
    }

    public boolean isInitialOpen() {
        return this.initialOpen;
    }

    public DriverFactory getFactory() {
        return this.factory;
    }

    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        this.disposeConnection();
    }

    public void update(ConnectionInformation connectionInformation) {
    }

    public void serviceChange(ServiceReference<DriverFactory> reference, DriverFactory factory) {
        logger.info("Service changed: {} / {} ({}:{})", new Object[]{reference, factory, this.connectionInformation.getInterface(), this.connectionInformation.getDriver()});
        this.disposeConnection();
        this.factory = factory;
        if (this.factory != null) {
            this.createAndRegisterConnection();
        }
    }

    protected abstract AbstractConnectionService createConnection();

    protected abstract Set<String> getInterfaces();

    private void createAndRegisterConnection() {
        logger.debug("Creating new connection");
        this.connection = this.createConnection();
        if (this.connection != null) {
            if (this.initialOpen) {
                logger.debug("Initially open");
                this.connection.connect();
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (this.connectionId != null) {
                properties.put("service.pid", this.connectionId);
            }
            properties.put("interface", this.connectionInformation.getInterface());
            properties.put("driver", this.connectionInformation.getDriver());
            properties.put("connection.uri", this.connectionInformation.toString());
            logger.info("Registered new connection service: {}", properties);
            HashSet<String> interfaces = new HashSet<String>(this.getInterfaces());
            interfaces.add(ConnectionService.class.getName());
            this.serviceReg = this.context.registerService(interfaces.toArray(new String[interfaces.size()]), (Object)this.connection, properties);
        }
    }

    protected void disposeConnection() {
        if (this.serviceReg != null) {
            logger.info("We got an old service ... dispose");
            AbstractConnectionService connection = this.connection;
            this.connection = null;
            this.serviceReg.unregister();
            this.serviceReg = null;
            connection.dispose();
        }
    }

    public void addRequest(ConnectionRequest request) {
        this.requests.add(request);
    }

    public void removeRequest(ConnectionRequest request) {
        this.requests.remove(request);
    }

    public boolean isIdle() {
        return this.requests.isEmpty();
    }
}

