/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItem;
import org.eclipse.scada.da.client.ItemManager;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;

public class AsyncDataItem
extends DataItem {
    private final ExecutorService executor;

    public AsyncDataItem(String itemId) {
        this(itemId, null);
    }

    public AsyncDataItem(String itemId, ItemManager connection) {
        this(itemId, connection, Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("AsyncDataItem/" + itemId)));
    }

    public AsyncDataItem(String itemId, ItemManager connection, ExecutorService executor) {
        super(itemId);
        this.executor = executor;
        if (connection != null) {
            this.register(connection);
        }
    }

    @Override
    protected void performNotifyDataChange(final Variant value, final Map<String, Variant> attributes, final boolean cache) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncDataItem.this.handlePerformNotifyDataChange(value, attributes, cache);
            }
        });
    }

    @Override
    protected void performNotifySubscriptionChange(final SubscriptionState subscriptionState, final Throwable subscriptionError) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncDataItem.this.handlePerformNotifySubscriptionChange(subscriptionState, subscriptionError);
            }
        });
    }

    protected void finalize() throws Throwable {
        this.executor.shutdown();
        super.finalize();
    }
}

