/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.eclipse.scada.utils.stats.StatisticsImpl;

public class StatisticsFilter
extends IoFilterAdapter {
    public static final AttributeKey STATS_KEY = new AttributeKey(StatisticsFilter.class, "stats");
    private static final Object STATS_READ_BYTES = new Object();
    private static final Object STATS_WRITTEN_BYTES = new Object();
    private static final Object STATS_SCHEDULED_WRITE_BYTES = new Object();
    private static final Object STATS_READ_BYTES_THROUGHPUT = new Object();
    private static final Object STATS_WRITTEN_BYTES_THROUGHPUT = new Object();
    public static final String DEFAULT_NAME = "core.stats";
    private final Set<StatisticsImpl> statsMapper = Collections.synchronizedSet(new HashSet());

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.statsMapper.remove(session);
        super.sessionClosed(nextFilter, session);
    }

    private StatisticsImpl getStats(IoSession session) {
        Object o = session.getAttribute((Object)STATS_KEY);
        if (o instanceof StatisticsImpl) {
            StatisticsImpl stats = (StatisticsImpl)o;
            if (this.statsMapper.add(stats)) {
                this.init(stats);
            }
            return stats;
        }
        return null;
    }

    private void init(StatisticsImpl stats) {
        stats.setLabel(STATS_READ_BYTES, "Read bytes");
        stats.setLabel(STATS_WRITTEN_BYTES, "Written bytes");
        stats.setLabel(STATS_SCHEDULED_WRITE_BYTES, "Scheduled write bytes");
        stats.setLabel(STATS_READ_BYTES_THROUGHPUT, "Read bytes throughput");
        stats.setLabel(STATS_WRITTEN_BYTES_THROUGHPUT, "Written bytes throughput");
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.updateStats(session);
        super.filterWrite(nextFilter, session, writeRequest);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.updateStats(session);
        super.messageReceived(nextFilter, session, message);
    }

    private void updateStats(IoSession session) {
        StatisticsImpl stats = this.getStats(session);
        if (stats != null) {
            stats.setCurrentValue(STATS_READ_BYTES, (double)session.getReadBytes());
            stats.setCurrentValue(STATS_WRITTEN_BYTES, (double)session.getWrittenBytes());
            stats.setCurrentValue(STATS_SCHEDULED_WRITE_BYTES, (double)session.getScheduledWriteBytes());
            stats.setCurrentValue(STATS_READ_BYTES_THROUGHPUT, session.getReadBytesThroughput());
            stats.setCurrentValue(STATS_WRITTEN_BYTES_THROUGHPUT, session.getWrittenBytesThroughput());
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.updateStats(session);
        super.messageSent(nextFilter, session, writeRequest);
    }
}

