/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authn;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.PasswordCallback;
import org.eclipse.scada.sec.callback.UserNameCallback;
import org.eclipse.scada.sec.utils.password.PasswordEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsRequest {
    private static final Logger logger = LoggerFactory.getLogger(CredentialsRequest.class);
    private static final int ORDER_USERNAME = 100;
    private static final int ORDER_PASSWORD = 200;
    private static final Object TAG_USERNAME = new Object();
    private static final Object TAG_PASSWORD = new Object();
    private final Map<Object, Callback> callbackMap = new HashMap<Object, Callback>();
    private final Locale locale;
    private final ResourceBundle bundle;
    private final List<List<PasswordEncoding>> passwordEncodings = new LinkedList<List<PasswordEncoding>>();

    public CredentialsRequest() {
        this(null);
    }

    public CredentialsRequest(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.bundle = ResourceBundle.getBundle("org/eclipse/scada/sec/authn/request", this.locale);
    }

    protected String getText(String textId, Locale locale) {
        return this.bundle.getString(textId);
    }

    public void askUsername() {
        logger.debug("Ask for username");
        if (!this.callbackMap.containsKey(TAG_USERNAME)) {
            logger.debug("Add username callback");
            this.callbackMap.put(TAG_USERNAME, new UserNameCallback(this.getText("username", this.locale), 100));
        }
    }

    public void askPassword(PasswordEncoding type) {
        this.askPassword(Collections.singletonList(type));
    }

    public void askPassword(List<PasswordEncoding> types) {
        logger.debug("Asking for password: {}", types);
        if (!this.callbackMap.containsKey(TAG_PASSWORD)) {
            logger.debug("Add password callback");
            this.callbackMap.put(TAG_PASSWORD, new PasswordCallback(this.getText("password", this.locale), 200));
        }
        this.passwordEncodings.add(types);
    }

    public Callback[] buildCallbacks() {
        logger.debug("Building callbacks for: {}", (Object)this);
        Callback[] result = this.callbackMap.values().toArray(new Callback[this.callbackMap.size()]);
        Arrays.sort(result, Callback.ORDER_COMPARATOR);
        Callback[] callbackArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Callback cb = callbackArray[n2];
            if (cb instanceof PasswordCallback) {
                this.fillPasswordTypes((PasswordCallback)cb);
            }
            ++n2;
        }
        return result;
    }

    private void fillPasswordTypes(PasswordCallback cb) {
        cb.setRequestedTypes(this.passwordEncodings);
    }

    public Callback getCallback(Object tag) {
        return this.callbackMap.get(tag);
    }

    public <T> T getTypedCallback(Object tag, Class<T> clazz) {
        Callback cb = this.getCallback(tag);
        if (cb != null && !clazz.isInstance(cb)) {
            return null;
        }
        return (T)cb;
    }

    public UserNameCallback getUserNameCallback() {
        return this.getTypedCallback(TAG_USERNAME, UserNameCallback.class);
    }

    public PasswordCallback getPasswordCallback() {
        return this.getTypedCallback(TAG_PASSWORD, PasswordCallback.class);
    }

    public String getUserName() {
        UserNameCallback cb = this.getUserNameCallback();
        if (cb == null) {
            return null;
        }
        return cb.getValue();
    }

    public Map<PasswordEncoding, String> getPasswords() {
        PasswordCallback cb = this.getPasswordCallback();
        if (cb == null) {
            return null;
        }
        return cb.getPasswords();
    }

    public String getPassword(PasswordEncoding type) {
        Map<PasswordEncoding, String> passwords = this.getPasswords();
        if (passwords == null) {
            return null;
        }
        return passwords.get(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[CredentialsRequest - ");
        for (Map.Entry<Object, Callback> entry : this.callbackMap.entrySet()) {
            sb.append("\n");
            sb.append("[");
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(entry.getValue());
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

