/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.callback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.sec.callback.LabelCallback;
import org.eclipse.scada.sec.utils.password.PasswordEncoding;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordCallback
extends LabelCallback {
    private static final Logger logger = LoggerFactory.getLogger(PasswordCallback.class);
    private static final String REQUESTED_TYPES_PREFIX = "password.requestedTypes.";
    public static final String TYPE = "password";
    private List<List<PasswordEncoding>> requestedTypes = new LinkedList<List<PasswordEncoding>>();
    private final Map<PasswordEncoding, String> passwords = new HashMap<PasswordEncoding, String>();
    private static final String PASSWORD_PREFIX = "password.";

    public PasswordCallback(String label, int order) {
        super(label, order);
    }

    public PasswordCallback(String label, int order, PasswordEncoding ... types) {
        super(label, order);
        this.requestedTypes.add(Arrays.asList(types));
    }

    public PasswordCallback(String label, int order, List<PasswordEncoding> types) {
        super(label, order);
        this.requestedTypes.add(new ArrayList<PasswordEncoding>(types));
    }

    public PasswordCallback() {
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setRequestedTypes(List<List<PasswordEncoding>> passwordEncodings) {
        this.requestedTypes = new ArrayList<List<PasswordEncoding>>(passwordEncodings);
    }

    public List<List<PasswordEncoding>> getRequestedTypes() {
        return Collections.unmodifiableList(this.requestedTypes);
    }

    public void addRequestedTypes(PasswordEncoding ... types) {
        this.requestedTypes.add(Arrays.asList(types));
    }

    public void addRequestedTypes(List<PasswordEncoding> types) {
        this.requestedTypes.add(types);
    }

    public void setPassword(String password) {
        this.passwords.clear();
        for (List<PasswordEncoding> group : this.requestedTypes) {
            if (group.isEmpty()) continue;
            PasswordEncoding encoding = group.get(0);
            try {
                this.passwords.put(encoding, encoding.encodeToHexString(password));
            }
            catch (Exception e) {
                logger.debug("Failed to encode type: " + encoding, (Throwable)e);
            }
        }
    }

    public Map<PasswordEncoding, String> getPasswords() {
        return Collections.unmodifiableMap(this.passwords);
    }

    public String getPassword(PasswordEncoding type) {
        return this.passwords.get(type);
    }

    public String getPlainPassword() {
        return this.getPassword(PasswordEncoding.PLAIN);
    }

    @Override
    protected void injectRequestAttributes(Map<String, String> request) {
        super.injectRequestAttributes(request);
        int i = 0;
        for (List<PasswordEncoding> group : this.requestedTypes) {
            request.put(REQUESTED_TYPES_PREFIX + i, StringHelper.join(group, (String)", "));
            ++i;
        }
    }

    @Override
    public void parseRequestAttributes(Map<String, String> attributes) {
        super.parseRequestAttributes(attributes);
        this.requestedTypes.clear();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String str;
            if (!entry.getKey().startsWith(REQUESTED_TYPES_PREFIX) || (str = entry.getValue()) == null) continue;
            LinkedList<PasswordEncoding> encodings = new LinkedList<PasswordEncoding>();
            for (String tok : Arrays.asList(str.split("\\s*,\\s*"))) {
                try {
                    encodings.add(PasswordEncoding.valueOf((String)tok));
                }
                catch (Exception e) {
                    logger.debug("Failed to parse requested encoding: " + tok, (Throwable)e);
                }
            }
            this.requestedTypes.add(encodings);
        }
    }

    @Override
    public void parseResponseAttributes(Map<String, String> attributes) {
        super.parseResponseAttributes(attributes);
        this.passwords.clear();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (!entry.getKey().startsWith(PASSWORD_PREFIX)) continue;
            String type = entry.getKey().substring(PASSWORD_PREFIX.length());
            try {
                this.passwords.put(PasswordEncoding.valueOf((String)type), entry.getValue());
            }
            catch (Exception e) {
                logger.debug("Failed to decode password encoding: " + type, (Throwable)e);
            }
        }
    }

    @Override
    protected void injectResponseAttributes(Map<String, String> result) {
        super.injectResponseAttributes(result);
        for (Map.Entry<PasswordEncoding, String> entry : this.passwords.entrySet()) {
            result.put(PASSWORD_PREFIX + entry.getKey(), entry.getValue());
        }
    }
}

