/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.protocol.ngp.codec.impl;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.core.protocol.ngp.codec.Structures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStateUpdate
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(ItemStateUpdate.class);
    public static final int MESSAGE_CODE = 4100;

    public int getMessageCode() {
        return 4100;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.da.data.message.ItemStateUpdate.class;
    }

    public org.eclipse.scada.da.data.message.ItemStateUpdate decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 4100) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 4100, messageCode));
        }
        int numberOfFields = _data.get();
        String itemId = null;
        SubscriptionState subscriptionState = null;
        ErrorInformation errorInformation = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    itemId = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    subscriptionState = (SubscriptionState)_context.decodeEnum(_data, SubscriptionState.class);
                    break;
                }
                case 3: {
                    errorInformation = Structures.decodeErrorInformation((BinaryContext)_context, (IoBuffer)_data, (boolean)true);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.da.data.message.ItemStateUpdate(itemId, subscriptionState, errorInformation);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.da.data.message.ItemStateUpdate value = (org.eclipse.scada.da.data.message.ItemStateUpdate)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(4100);
        data.put((byte)3);
        context.encodeString(data, (byte)1, value.getItemId());
        context.encodeEnum(data, (byte)2, (Enum)value.getSubscriptionState());
        Structures.encodeErrorInformation((BinaryContext)context, (IoBuffer)data, (byte)3, (ErrorInformation)value.getErrorInformation());
        data.flip();
        return data;
    }
}

