/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc.protocol.serialize;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.protocol.ngp.common.mc.message.DataMessage;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.MessageDecoder;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.MessageEncoder;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.MessageProtocol;

public class ObjectSerializationProtocol
implements MessageProtocol,
MessageEncoder,
MessageDecoder {
    private final ClassLoader classLoader;

    public ObjectSerializationProtocol() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ObjectSerializationProtocol(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public MessageEncoder getEncoder() {
        return this;
    }

    @Override
    public MessageDecoder getDecoder() {
        return this;
    }

    @Override
    public Object decodeMessage(DataMessage message) throws Exception {
        return message.getData().getObject(this.classLoader);
    }

    @Override
    public DataMessage encodeMessage(Object message) throws Exception {
        if (!(message instanceof Serializable)) {
            if (message != null) {
                throw new NotSerializableException(message.getClass().getName());
            }
            throw new NotSerializableException();
        }
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putObject(message);
        data.flip();
        return new DataMessage(data);
    }
}

