/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.connection.provider;

import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.connection.provider.AbstractConnectionService;
import org.eclipse.scada.core.connection.provider.info.ConnectionInformationProvider;
import org.eclipse.scada.da.client.FolderManager;
import org.eclipse.scada.da.client.ItemManager;
import org.eclipse.scada.da.client.ItemManagerImpl;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.connection.provider.internal.CountingItemManager;
import org.eclipse.scada.da.connection.provider.internal.LazyConnectionWrapper;

public class ConnectionServiceImpl
extends AbstractConnectionService
implements ConnectionService {
    private static final Object GET_ON_IM = new Object();
    private final ItemManager itemManager;
    private final FolderManager folderManager;
    private final org.eclipse.scada.da.client.Connection connection;
    private boolean shouldConnect;

    public ConnectionServiceImpl(org.eclipse.scada.da.client.Connection connection, Integer autoReconnectController, boolean lazyActivation) {
        super(autoReconnectController, lazyActivation);
        this.connection = lazyActivation ? new LazyConnectionWrapper(connection, autoReconnectController){

            @Override
            protected void performDisconnect() {
                ConnectionServiceImpl.this.setShouldConnect(false);
            }

            @Override
            protected void performConnect() {
                ConnectionServiceImpl.this.setShouldConnect(true);
            }
        } : connection;
        this.setConnection((Connection)this.connection);
        this.itemManager = new CountingItemManager((ItemManager)new ItemManagerImpl(this.connection), this.statistics);
        this.folderManager = new FolderManager(this.connection);
        this.statistics.setLabel(GET_ON_IM, "getItemManager called");
        this.statistics.setLabel(CountingItemManager.REGISTERED_ITEMS, "Registered items");
    }

    protected synchronized void setShouldConnect(boolean state) {
        this.shouldConnect = state;
        this.checkConnect();
    }

    protected boolean shouldConnect() {
        return this.shouldConnect;
    }

    @Override
    public org.eclipse.scada.da.client.Connection getConnection() {
        return this.connection;
    }

    @Override
    public FolderManager getFolderManager() {
        return this.folderManager;
    }

    @Override
    public ItemManager getItemManager() {
        this.statistics.changeCurrentValue(GET_ON_IM, 1.0);
        return this.itemManager;
    }

    public Class<?>[] getSupportedInterfaces() {
        return new Class[]{org.eclipse.scada.core.connection.provider.ConnectionService.class, ConnectionService.class, ConnectionInformationProvider.class};
    }
}

