/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.propertyeditors;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.scada.utils.propertyeditors.BooleanEditor;
import org.eclipse.scada.utils.propertyeditors.ByteEditor;
import org.eclipse.scada.utils.propertyeditors.DateEditor;
import org.eclipse.scada.utils.propertyeditors.DoubleEditor;
import org.eclipse.scada.utils.propertyeditors.FloatEditor;
import org.eclipse.scada.utils.propertyeditors.IntegerEditor;
import org.eclipse.scada.utils.propertyeditors.LongEditor;
import org.eclipse.scada.utils.propertyeditors.NumberEditor;
import org.eclipse.scada.utils.propertyeditors.ShortEditor;
import org.eclipse.scada.utils.propertyeditors.StringEditor;
import org.eclipse.scada.utils.propertyeditors.UUIDEditor;

public class PropertyEditorRegistry {
    private final ConcurrentMap<String, PropertyEditor> propertyEditors = new ConcurrentHashMap<String, PropertyEditor>();

    public PropertyEditorRegistry() {
        this(false);
    }

    public PropertyEditorRegistry(boolean fillWithDefault) {
        if (fillWithDefault) {
            this.registerCustomEditor(Boolean.class, new BooleanEditor());
            this.registerCustomEditor(Boolean.TYPE, new BooleanEditor());
            this.registerCustomEditor(Byte.class, new ByteEditor());
            this.registerCustomEditor(Byte.TYPE, new ByteEditor());
            this.registerCustomEditor(Double.class, new DoubleEditor());
            this.registerCustomEditor(Double.TYPE, new DoubleEditor());
            this.registerCustomEditor(Float.class, new FloatEditor());
            this.registerCustomEditor(Float.TYPE, new FloatEditor());
            this.registerCustomEditor(Integer.class, new IntegerEditor());
            this.registerCustomEditor(Integer.TYPE, new IntegerEditor());
            this.registerCustomEditor(Long.class, new LongEditor());
            this.registerCustomEditor(Long.TYPE, new LongEditor());
            this.registerCustomEditor(Short.class, new ShortEditor());
            this.registerCustomEditor(Short.TYPE, new ShortEditor());
            this.registerCustomEditor(String.class, new StringEditor());
            this.registerCustomEditor(Date.class, new DateEditor());
            this.registerCustomEditor(UUID.class, new UUIDEditor());
            this.registerCustomEditor(Number.class, new NumberEditor());
        }
    }

    public Map<String, PropertyEditor> getPropertyEditors() {
        return Collections.unmodifiableMap(this.propertyEditors);
    }

    public PropertyEditor findCustomEditor(Class<?> requiredType, String propertyPath) {
        String key = String.valueOf(requiredType.getCanonicalName()) + ":" + propertyPath;
        PropertyEditor pe = (PropertyEditor)this.propertyEditors.get(key);
        if (pe == null) {
            key = String.valueOf(requiredType.getCanonicalName()) + ":";
            pe = (PropertyEditor)this.propertyEditors.get(key);
        }
        if (pe == null) {
            pe = PropertyEditorManager.findEditor(requiredType);
        }
        return pe;
    }

    public PropertyEditor findCustomEditor(Class<?> requiredType) {
        return this.findCustomEditor(requiredType, "");
    }

    public final void registerCustomEditor(Class<?> requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, "", propertyEditor);
    }

    public void registerCustomEditor(Class<?> requiredType, String propertyPath, PropertyEditor propertyEditor) {
        String key = String.valueOf(requiredType.getCanonicalName()) + ":" + propertyPath;
        this.propertyEditors.put(key, propertyEditor);
    }
}

