/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInformation
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionInformation.class);
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_USER = "user";
    private static final String URI_ENCODING = "utf-8";
    private String interfaceName;
    private String driver;
    private String target;
    private Integer secondaryTarget;
    private List<String> subtargets = new LinkedList<String>();
    private Map<String, String> properties = new HashMap<String, String>();

    public static ConnectionInformation fromURI(String uri) {
        return ConnectionInformation.fromURI(URI.create(uri));
    }

    public static ConnectionInformation fromURI(URI uri) {
        ConnectionInformation ci;
        URI subUri;
        block16: {
            subUri = URI.create(uri.getRawSchemeSpecificPart());
            ci = new ConnectionInformation();
            ci.interfaceName = uri.getScheme();
            ci.driver = subUri.getScheme();
            if (subUri.getHost() != null) break block16;
            return null;
        }
        try {
            ci.target = URLDecoder.decode(subUri.getHost(), URI_ENCODING);
            if (subUri.getPort() >= 0) {
                ci.secondaryTarget = subUri.getPort();
            }
            if (subUri.getPath() != null) {
                String path = subUri.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.length() > 0) {
                    ci.subtargets = new LinkedList<String>(Arrays.asList(path.split("\\/")));
                }
            }
            if (subUri.getUserInfo() != null) {
                String[] userInfo = subUri.getRawUserInfo().split("\\:");
                if (userInfo.length > 0) {
                    ci.properties.put(PROP_USER, URLDecoder.decode(userInfo[0], URI_ENCODING));
                }
                if (userInfo.length > 1) {
                    ci.properties.put(PROP_PASSWORD, URLDecoder.decode(userInfo[1], URI_ENCODING));
                }
            }
            if (subUri.getRawQuery() != null && subUri.getRawQuery().length() > 0) {
                Pattern p = Pattern.compile("(.*?)=(.*)");
                String[] stringArray = subUri.getRawQuery().split("\\&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    Matcher m = p.matcher(pair);
                    if (m.matches()) {
                        String key = URLDecoder.decode(m.group(1), URI_ENCODING);
                        String value = URLDecoder.decode(m.group(2), URI_ENCODING);
                        ci.properties.put(key, value);
                    } else {
                        ci.properties.put(URLDecoder.decode(pair, URI_ENCODING), "");
                    }
                    ++n2;
                }
            }
            if (ci.getInterface() == null) {
                throw new IllegalArgumentException("URI has no interface");
            }
            if (ci.getDriver() == null) {
                throw new IllegalArgumentException("URI has no driver");
            }
            return ci;
        }
        catch (Exception e) {
            logger.warn("Failed to decode URI", (Throwable)e);
            return null;
        }
    }

    public void setUser(String user) {
        if (user != null) {
            this.properties.put(PROP_USER, user);
        } else {
            this.properties.remove(PROP_USER);
        }
    }

    public void setPassword(String password) {
        if (password != null) {
            this.properties.put(PROP_PASSWORD, password);
        } else {
            this.properties.remove(PROP_PASSWORD);
        }
    }

    public String getPassword() {
        return this.properties.get(PROP_PASSWORD);
    }

    public String getUser() {
        return this.properties.get(PROP_USER);
    }

    public URI toUri() {
        HashMap<String, String> properties = new HashMap<String, String>(this.properties);
        String user = (String)properties.remove(PROP_USER);
        String password = (String)properties.remove(PROP_PASSWORD);
        try {
            String query = this.makeQuery(properties);
            String path = this.makePath();
            String userInfo = user == null && password == null ? null : (user != null && password == null ? user : String.valueOf(user) + ":" + password);
            String target = this.target == null ? "" : (this.target.indexOf(37) >= 0 ? this.target.replace("%", "%25") : this.target);
            return new URI(String.valueOf(this.interfaceName) + ":" + this.driver, userInfo, target, this.secondaryTarget, path, query, null);
        }
        catch (Exception e) {
            logger.warn("Failed to convert", (Throwable)e);
            return null;
        }
    }

    private String makeQuery(Map<String, String> properties) throws UnsupportedEncodingException {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = URLEncoder.encode(entry.getKey(), URI_ENCODING);
            String value = URLEncoder.encode(entry.getValue(), URI_ENCODING);
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append('=').append(value);
        }
        return sb.toString();
    }

    private String makePath() {
        if (this.subtargets == null || this.subtargets.isEmpty()) {
            return null;
        }
        return "/" + StringHelper.join(this.subtargets, (String)"/");
    }

    public String toString() {
        URI uri = this.toUri();
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public void setInterface(String interface1) {
        this.interfaceName = interface1;
    }

    public Integer getSecondaryTarget() {
        return this.secondaryTarget;
    }

    public void setSecondaryTarget(Integer secondaryTarget) {
        this.secondaryTarget = secondaryTarget;
    }

    public List<String> getSubtargets() {
        return this.subtargets;
    }

    public void setSubtargets(List<String> subtargets) {
        this.subtargets = subtargets;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isValid() {
        return this.driver != null && this.interfaceName != null && this.properties != null && this.subtargets != null && this.target != null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.secondaryTarget == null ? 0 : this.secondaryTarget.hashCode());
        result = 31 * result + (this.subtargets == null ? 0 : this.subtargets.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionInformation)) {
            return false;
        }
        ConnectionInformation other = (ConnectionInformation)obj;
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.secondaryTarget == null ? other.secondaryTarget != null : !this.secondaryTarget.equals(other.secondaryTarget)) {
            return false;
        }
        if (this.subtargets == null ? other.subtargets != null : !this.subtargets.equals(other.subtargets)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public ConnectionInformation clone() {
        ConnectionInformation connectionInformation = new ConnectionInformation();
        connectionInformation.driver = this.driver;
        connectionInformation.interfaceName = this.interfaceName;
        connectionInformation.properties = new HashMap<String, String>(this.properties);
        connectionInformation.secondaryTarget = this.secondaryTarget;
        connectionInformation.subtargets = new LinkedList<String>(this.subtargets);
        connectionInformation.target = this.target;
        return connectionInformation;
    }

    public String toMaskedString(String mask) {
        ConnectionInformation connectionInformation = this.clone();
        String password = connectionInformation.getPassword();
        if (password != null) {
            connectionInformation.setPassword(mask);
        }
        return connectionInformation.toString();
    }

    public String toMaskedString() {
        return this.toMaskedString("***");
    }
}

