/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core;

import java.io.Serializable;
import java.math.BigDecimal;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.VariantComparator;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class Variant
implements Serializable,
Comparable<Variant> {
    private static final long serialVersionUID = 1L;
    public static final Variant NULL = new Variant();
    public static final Variant TRUE = new Variant(true);
    public static final Variant FALSE = new Variant(false);
    private static final int MAX_PRE_INSTANCES = 256;
    private static final Variant[] preIntInstances = new Variant[256];
    private static final Variant[] preLongInstances = new Variant[256];
    private static final VariantComparator comparator;
    private Serializable value;

    static {
        int i = 0;
        while (i < preIntInstances.length) {
            Variant.preIntInstances[i] = new Variant(i);
            Variant.preLongInstances[i] = new Variant((long)i);
            ++i;
        }
        comparator = new VariantComparator();
    }

    public static Variant valueOf(long value) {
        if (value >= 0L && value < (long)preLongInstances.length) {
            return preLongInstances[(int)value];
        }
        return new Variant(value);
    }

    public static Variant valueOf(int value) {
        if (value >= 0 && value < preIntInstances.length) {
            return preIntInstances[value];
        }
        return new Variant(value);
    }

    public static Variant valueOf(double value) {
        return new Variant(value);
    }

    public static Variant valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Variant valueOf(Object value) {
        if (value == null) {
            return NULL;
        }
        if (value instanceof Variant) {
            return (Variant)value;
        }
        if (value instanceof Boolean) {
            return Variant.valueOf((Boolean)value);
        }
        if (value instanceof Long) {
            return Variant.valueOf((Long)value);
        }
        if (value instanceof Integer) {
            return Variant.valueOf((Integer)value);
        }
        if (value instanceof Double) {
            return Variant.valueOf((Double)value);
        }
        return new Variant(value);
    }

    protected Variant() {
    }

    protected Variant(Object object) {
        this.setValue(object);
    }

    protected Variant(boolean value) {
        this.setValue(value);
    }

    protected Variant(double value) {
        this.setValue(value);
    }

    protected Variant(int value) {
        this.setValue(value);
    }

    protected Variant(long value) {
        this.setValue(value);
    }

    protected Variant(String value) {
        this.setValue(value);
    }

    protected Variant(Variant other) {
        this(other != null ? other.value : null);
    }

    public boolean isNull() {
        return this.value == null;
    }

    private void setValue(Object value) {
        if (value == null) {
            this.value = null;
        } else if (value instanceof Variant) {
            this.setValue(((Variant)value).value);
        } else if (value instanceof Short) {
            this.setValue(((Short)value).intValue());
        } else if (value instanceof Long) {
            this.setValue((Long)value);
        } else if (value instanceof Integer) {
            this.setValue((Integer)value);
        } else if (value instanceof String) {
            this.setValue((String)value);
        } else if (value instanceof Boolean) {
            this.setValue((Boolean)value);
        } else if (value instanceof Double) {
            this.setValue((Double)value);
        } else if (value instanceof Float) {
            this.setValue(((Float)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            this.setValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Number) {
            this.setValue(((Number)value).longValue());
        } else {
            this.setValue(value.toString());
        }
    }

    private void setValue(boolean value) {
        this.value = Boolean.valueOf(value);
    }

    private void setValue(int value) {
        this.value = Integer.valueOf(value);
    }

    private void setValue(long value) {
        this.value = Long.valueOf(value);
    }

    private void setValue(String value) {
        this.value = value != null ? value : null;
    }

    private void setValue(double value) {
        this.value = Double.valueOf(value);
    }

    public String asString() throws NullValueException {
        if (this.isNull()) {
            throw new NullValueException();
        }
        return this.value.toString();
    }

    public String asString(String defaultValue) {
        if (this.isNull()) {
            return defaultValue;
        }
        return this.value.toString();
    }

    public Double asDouble(Double defaultValue) {
        try {
            return this.asDouble();
        }
        catch (NullValueException nullValueException) {
            return defaultValue;
        }
        catch (NotConvertableException notConvertableException) {
            return defaultValue;
        }
    }

    public double asDouble() throws NullValueException, NotConvertableException {
        if (this.isNull()) {
            throw new NullValueException();
        }
        try {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value != false ? 1.0 : 0.0;
            }
            if (this.value instanceof Double) {
                return (Double)this.value;
            }
            if (this.value instanceof Integer) {
                return ((Integer)this.value).doubleValue();
            }
            if (this.value instanceof Long) {
                return ((Long)this.value).doubleValue();
            }
            if (this.value instanceof String) {
                return Double.parseDouble((String)((Object)this.value));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NotConvertableException(this.value);
        }
        throw new NotConvertableException(this.value);
    }

    public Integer asInteger(Integer defaultValue) {
        try {
            return this.asInteger();
        }
        catch (NullValueException nullValueException) {
            return defaultValue;
        }
        catch (NotConvertableException notConvertableException) {
            return defaultValue;
        }
    }

    public int asInteger() throws NullValueException, NotConvertableException {
        if (this.isNull()) {
            throw new NullValueException();
        }
        try {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value != false ? 1 : 0;
            }
            if (this.value instanceof Double) {
                return ((Double)this.value).intValue();
            }
            if (this.value instanceof Integer) {
                return (Integer)this.value;
            }
            if (this.value instanceof Long) {
                return ((Long)this.value).intValue();
            }
            if (this.value instanceof String) {
                return Integer.parseInt((String)((Object)this.value));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NotConvertableException(this.value);
        }
        throw new NotConvertableException(this.value);
    }

    public Long asLong(Long defaultValue) {
        try {
            return this.asLong();
        }
        catch (NullValueException nullValueException) {
            return defaultValue;
        }
        catch (NotConvertableException notConvertableException) {
            return defaultValue;
        }
    }

    public long asLong() throws NullValueException, NotConvertableException {
        if (this.isNull()) {
            throw new NullValueException();
        }
        try {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value != false ? 1L : 0L;
            }
            if (this.value instanceof Double) {
                return ((Double)this.value).longValue();
            }
            if (this.value instanceof Integer) {
                return ((Integer)this.value).longValue();
            }
            if (this.value instanceof Long) {
                return (Long)this.value;
            }
            if (this.value instanceof String) {
                return Long.parseLong((String)((Object)this.value));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NotConvertableException(this.value);
        }
        throw new NotConvertableException(this.value);
    }

    public boolean asBoolean() {
        block13: {
            String str;
            block14: {
                block12: {
                    try {
                        if (this.value != null) break block12;
                        return false;
                    }
                    catch (Exception exception) {}
                }
                if (this.value instanceof Boolean) {
                    return (Boolean)this.value;
                }
                if (this.value instanceof Double) {
                    return (Double)this.value != 0.0;
                }
                if (this.value instanceof Integer) {
                    return (Integer)this.value != 0;
                }
                if (this.value instanceof Long) {
                    return (Long)this.value != 0L;
                }
                if (!(this.value instanceof String)) break block13;
                str = (String)((Object)this.value);
                if (str.length() != 0) break block14;
                return false;
            }
            try {
                long i = Long.parseLong(str);
                return i != 0L;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    double i = Double.parseDouble(str);
                    return i != 0.0;
                }
                catch (NumberFormatException numberFormatException2) {
                    return Boolean.parseBoolean(str);
                }
            }
        }
        return false;
    }

    public Boolean asBoolean(Boolean defaultValue) {
        if (this.isNull()) {
            return defaultValue;
        }
        return this.asBoolean();
    }

    public Serializable as(VariantType variantType, Serializable defaultValue) {
        if (variantType == null) {
            return this.getValue();
        }
        switch (variantType) {
            case BOOLEAN: {
                return this.asBoolean((Boolean)defaultValue);
            }
            case DOUBLE: {
                return this.asDouble((Double)defaultValue);
            }
            case INT32: {
                return this.asInteger((Integer)defaultValue);
            }
            case INT64: {
                return this.asLong((Long)defaultValue);
            }
            case STRING: {
                return this.asString((String)((Object)defaultValue));
            }
            case NULL: {
                return null;
            }
            case UNKNOWN: {
                return this.getValue();
            }
        }
        return this.getValue();
    }

    public Serializable as(VariantType variantType) throws NullValueException, NotConvertableException {
        if (variantType == null) {
            return this.getValue();
        }
        switch (variantType) {
            case BOOLEAN: {
                return Boolean.valueOf(this.asBoolean());
            }
            case DOUBLE: {
                return Double.valueOf(this.asDouble());
            }
            case INT32: {
                return Integer.valueOf(this.asInteger());
            }
            case INT64: {
                return Long.valueOf(this.asLong());
            }
            case STRING: {
                return this.asString();
            }
            case NULL: {
                return null;
            }
            case UNKNOWN: {
                return this.getValue();
            }
        }
        return this.getValue();
    }

    public boolean isBoolean() {
        if (this.isNull()) {
            return false;
        }
        return this.value instanceof Boolean;
    }

    public boolean isString() {
        if (this.isNull()) {
            return false;
        }
        return this.value instanceof String;
    }

    public boolean isDouble() {
        if (this.isNull()) {
            return false;
        }
        return this.value instanceof Double;
    }

    public boolean isInteger() {
        if (this.isNull()) {
            return false;
        }
        return this.value instanceof Integer;
    }

    public boolean isLong() {
        if (this.isNull()) {
            return false;
        }
        return this.value instanceof Long;
    }

    public boolean isNumber() {
        if (this.isNull()) {
            return false;
        }
        return this.value instanceof Number;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Variant)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Variant other = (Variant)obj;
        try {
            if (other.isNull()) {
                return this.isNull();
            }
            if (this.isNull()) {
                return other.isNull();
            }
            if (other.isBoolean()) {
                return this.compareToBoolean(other.asBoolean());
            }
            if (other.isDouble()) {
                return this.compareToDouble(other.asDouble());
            }
            if (other.isLong()) {
                return this.compareToLong(other.asLong());
            }
            if (other.isInteger()) {
                return this.compareToInteger(other.asInteger());
            }
            if (other.isString()) {
                return this.compareToString(other.asString());
            }
            return false;
        }
        catch (NullValueException nullValueException) {
            return false;
        }
        catch (NotConvertableException notConvertableException) {
            return false;
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return 31;
        }
        return this.value.hashCode();
    }

    private boolean compareToString(String s) {
        if (this.isNull()) {
            return false;
        }
        try {
            if (this.isDouble()) {
                return this.asDouble() == Double.parseDouble(s);
            }
            if (this.isBoolean()) {
                return this.asBoolean() == new Variant(s).asBoolean();
            }
            if (this.isLong()) {
                return this.asLong() == Long.parseLong(s);
            }
            if (this.isInteger()) {
                return this.asInteger() == Integer.parseInt(s);
            }
            return this.asString().equals(s);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean compareToInteger(int i) {
        if (this.isNull()) {
            return false;
        }
        try {
            if (this.isDouble()) {
                return this.asDouble() == (double)i;
            }
            if (this.isBoolean()) {
                return this.asBoolean() ? i != 0 : i == 0;
            }
            if (this.isLong()) {
                return this.asLong() == (long)i;
            }
            return this.asInteger() == i;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean compareToLong(long l) {
        if (this.isNull()) {
            return false;
        }
        try {
            if (this.isDouble()) {
                return this.asDouble() == (double)l;
            }
            if (this.isBoolean()) {
                return this.asBoolean() ? l != 0L : l == 0L;
            }
            return this.asLong() == l;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean compareToDouble(double d) {
        if (this.isNull()) {
            return false;
        }
        try {
            if (this.isBoolean()) {
                return this.asBoolean() ? d != 0.0 : d == 0.0;
            }
            return this.asDouble() == d;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean compareToBoolean(boolean b) {
        return this.asBoolean() == b;
    }

    public String toLabel(String defaultLabel) {
        if (this.value == null) {
            return defaultLabel;
        }
        return this.value.toString();
    }

    public String toLabel() {
        return this.toLabel("");
    }

    public String toString() {
        return (Object)((Object)VariantType.fromJavaObject(this.value)) + "#" + this.toLabel();
    }

    public VariantType getType() {
        return VariantType.fromJavaObject(this.value);
    }

    public Serializable getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Variant o) {
        return comparator.compare(this, o);
    }
}

