/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core;

import java.beans.PropertyEditorSupport;
import org.eclipse.scada.core.Variant;

public class VariantEditor
extends PropertyEditorSupport {
    public static Variant toVariant(String type, String value) {
        if (type == null || value == null) {
            return null;
        }
        if (type.equalsIgnoreCase("INT") || type.equalsIgnoreCase("INT32") || type.equalsIgnoreCase("INTEGER")) {
            return Variant.valueOf(Integer.parseInt(value));
        }
        if (type.equalsIgnoreCase("BOOLEAN") || type.equalsIgnoreCase("BOOL")) {
            return Variant.valueOf(Boolean.parseBoolean(value));
        }
        if (type.equalsIgnoreCase("DOUBLE") || type.equalsIgnoreCase("FLOAT")) {
            return Variant.valueOf(Double.parseDouble(value));
        }
        if (type.equalsIgnoreCase("LONG") || type.equalsIgnoreCase("INT64")) {
            return Variant.valueOf(Long.parseLong(value));
        }
        if (type.equalsIgnoreCase("STRING") || type.equalsIgnoreCase("UNKNOWN")) {
            return Variant.valueOf(value);
        }
        if (type.equalsIgnoreCase("NULL")) {
            return Variant.NULL;
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid variant type", type));
    }

    public static Variant toVariant(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        String[] toks = text.split("#", 2);
        if (toks.length > 1) {
            return VariantEditor.toVariant(toks[0], toks[1]);
        }
        return Variant.valueOf(text);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(VariantEditor.toVariant(text));
    }
}

