/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.ui.blink.AbstractBlinker;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.vi.model.Figure;
import org.eclipse.scada.vi.model.SystemCursor;
import org.eclipse.scada.vi.model.VisualInterfaceFactory;
import org.eclipse.scada.vi.ui.draw2d.Controller;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.primitives.Helper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class FigureController
implements Controller {
    protected final ResourceManager manager;
    private final SymbolController controller;
    private ScriptExecutor onClick;
    private ScriptExecutor onDoubleClick;
    private final Map<Object, ColorHandler> colorHandler = new HashMap<Object, ColorHandler>();
    private boolean started;

    public FigureController(SymbolController controller, ResourceManager manager) {
        this.manager = manager;
        this.controller = controller;
    }

    protected abstract IFigure getPropertyFigure();

    @Override
    public IFigure getFigure() {
        return this.getPropertyFigure();
    }

    protected void applyCommon(Figure figure) {
        this.setBorder(figure.getBorder());
        this.setBackgroundColor(figure.getBackgroundColor());
        this.setForegroundColor(figure.getForegroundColor());
        this.setPreferredSize(this.create(figure.getSize()));
        this.setCursor(this.convert(figure.getCursor()));
        this.setVisible(figure.isVisible());
        this.setOpaque(figure.getOpaque());
        this.setToolTip(figure.getToolTip());
        try {
            this.onClick = this.controller.createScriptExecutor(figure.getOnClick());
            this.onDoubleClick = this.controller.createScriptExecutor(figure.getOnDoubleClick());
        }
        catch (ScriptException e) {
            throw new RuntimeException("Failed to initialize", e);
        }
        if (this.onClick != null || this.onDoubleClick != null) {
            this.getPropertyFigure().addMouseListener((MouseListener)new ClickHandlerImpl());
        }
    }

    public void setToolTip(String string) {
        if (string == null) {
            this.getPropertyFigure().setToolTip(null);
        } else {
            this.getPropertyFigure().setToolTip((IFigure)new Label(string));
        }
    }

    public void setCursor(String cursor) {
        this.getPropertyFigure().setCursor(this.getCursor(cursor));
    }

    protected Cursor getCursor(String cursor) {
        try {
            SWTCursors cursorValue = SWTCursors.valueOf(cursor);
            return Display.getDefault().getSystemCursor(cursorValue.id());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String convert(org.eclipse.scada.vi.model.Cursor cursor) {
        if (cursor instanceof SystemCursor) {
            return ((SystemCursor)cursor).getType().toString();
        }
        return null;
    }

    protected void handleOnDoubleClick(MouseEvent me) {
        this.controller.debugLog(String.format("Double click: %s", me));
        LinkedHashMap<String, Object> scriptObjects = new LinkedHashMap<String, Object>(1);
        scriptObjects.put("event", me);
        try {
            this.controller.execute(this.onDoubleClick, scriptObjects);
        }
        catch (Exception e) {
            this.controller.errorLog("Failed to handle onDoubleClick", e);
        }
    }

    protected void handleOnClick(MouseEvent me) {
        this.controller.debugLog(String.format("Click: %s", me));
        LinkedHashMap<String, Object> scriptObjects = new LinkedHashMap<String, Object>(1);
        scriptObjects.put("event", me);
        try {
            this.controller.execute(this.onClick, scriptObjects);
        }
        catch (Exception e) {
            this.controller.errorLog("Failed to handle onClick", e);
        }
    }

    public void setPreferredSize(double width, double height) {
        this.setPreferredSize((Dimension)new PrecisionDimension(width, height));
    }

    public void setPreferredSize(Dimension size) {
        this.getPropertyFigure().setPreferredSize(size);
    }

    public void setSize(Dimension size) {
        if (size != null) {
            this.getPropertyFigure().setSize(size);
        }
    }

    public void setSize(double width, double height) {
        Rectangle b = this.getPropertyFigure().getBounds();
        this.getPropertyFigure().setBounds((Rectangle)new PrecisionRectangle(b.preciseX(), b.preciseY(), width, height));
    }

    public void setWidth(double width) {
        Rectangle b = this.getPropertyFigure().getBounds();
        this.getPropertyFigure().setBounds((Rectangle)new PrecisionRectangle(b.preciseX(), b.preciseY(), width, b.preciseHeight()));
    }

    public void setHeight(double height) {
        Rectangle b = this.getPropertyFigure().getBounds();
        this.getPropertyFigure().setBounds((Rectangle)new PrecisionRectangle(b.preciseX(), b.preciseY(), b.preciseWidth(), height));
    }

    public org.eclipse.scada.vi.model.Dimension getPreferredSize() {
        org.eclipse.scada.vi.model.Dimension dimension = VisualInterfaceFactory.eINSTANCE.createDimension();
        Dimension size = this.getPropertyFigure().getPreferredSize();
        dimension.setHeight(size.preciseWidth());
        dimension.setWidth(size.preciseWidth());
        return dimension;
    }

    public void setPreferredWidth(double value) {
        PrecisionDimension dim = new PrecisionDimension();
        dim.setPreciseWidth(value);
        dim.setPreciseHeight(this.getPropertyFigure().getPreferredSize().preciseHeight());
        this.getPropertyFigure().setPreferredSize((Dimension)dim);
    }

    public void setPreferredHeight(double value) {
        PrecisionDimension dim = new PrecisionDimension();
        dim.setPreciseWidth(this.getPropertyFigure().getPreferredSize().preciseWidth());
        dim.setPreciseHeight(value);
        this.getPropertyFigure().setPreferredSize((Dimension)dim);
    }

    public void setBorder(String border) {
        this.getPropertyFigure().setBorder(this.makeBorder(border));
    }

    public void setBackgroundColor(String color) {
        ColorHandler colorHandler = this.makeColorHandler(color, new BackgroundApplier());
        this.setColor("backgroundColor", colorHandler);
    }

    public void setForegroundColor(String color) {
        ColorHandler colorHandler = this.makeColorHandler(color, new ForegroundApplier());
        this.setColor("foregroundColor", colorHandler);
    }

    protected void setColor(Object key, ColorHandler colorHandler) {
        ColorHandler oldColorHandler = this.colorHandler.put(key, colorHandler);
        if (oldColorHandler != null) {
            oldColorHandler.stop();
        }
        if (this.started) {
            colorHandler.start();
        }
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        for (ColorHandler color : this.colorHandler.values()) {
            color.start();
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (ColorHandler color : this.colorHandler.values()) {
            color.stop();
        }
    }

    public void setVisible(boolean flag) {
        this.getPropertyFigure().setVisible(flag);
    }

    public abstract void setOpaque(Boolean var1);

    protected void setOpaque(Boolean flag, boolean defaultValue) {
        if (flag == null) {
            this.getPropertyFigure().setOpaque(defaultValue);
        } else {
            this.getPropertyFigure().setOpaque(flag.booleanValue());
        }
    }

    protected Border makeBorder(String border) {
        if (border == null || border.isEmpty()) {
            return null;
        }
        if (border.matches("[0-9]+")) {
            return new LineBorder(Integer.parseInt(border));
        }
        if (border.startsWith("LINE:")) {
            Map<String, String> args = this.parseBorderArguments("lineWidth", border.substring("LINE:".length()));
            LineBorder lineBorder = new LineBorder();
            if (args.containsKey("lineWidth")) {
                lineBorder.setWidth(Integer.parseInt(args.get("lineWidth")));
            }
            lineBorder.setColor(this.createColor(Helper.makeColor(args.get("color"))));
            return lineBorder;
        }
        if (border.startsWith("GROUP:")) {
            Color color;
            GroupBoxBorder groupBorder = new GroupBoxBorder();
            Map<String, String> args = this.parseBorderArguments("text", border.substring("GROUP:".length()));
            if (args.containsKey("text")) {
                groupBorder.setLabel(args.get("text"));
            }
            if ((color = this.createColor(Helper.makeColor(args.get("textColor")))) != null) {
                groupBorder.setTextColor(color);
            }
            return groupBorder;
        }
        if (border.startsWith("TITLE:")) {
            Color backgroundColor;
            Color color;
            TitleBarBorder titleBorder = new TitleBarBorder();
            Map<String, String> args = this.parseBorderArguments("text", border.substring("TITLE:".length()));
            if (args.containsKey("text")) {
                titleBorder.setLabel(args.get("text"));
            }
            if ((color = this.createColor(Helper.makeColor(args.get("textColor")))) != null) {
                titleBorder.setTextColor(color);
            }
            if ((backgroundColor = this.createColor(Helper.makeColor(args.get("backgroundColor")))) != null) {
                titleBorder.setBackgroundColor(backgroundColor);
            }
            return titleBorder;
        }
        if (border.startsWith("MARGIN:")) {
            Map<String, String> args = this.parseBorderArguments("inset", border.substring("MARGIN:".length()));
            if (args.containsKey("inset")) {
                String value = args.get("inset");
                if (value.contains(",")) {
                    String[] insets = args.get("inset").split(", ?");
                    return new MarginBorder(Integer.parseInt(insets[0]), Integer.parseInt(insets[1]), Integer.parseInt(insets[2]), Integer.parseInt(insets[3]));
                }
                return new MarginBorder(Integer.parseInt(args.get("inset")));
            }
            if (args.containsKey("t") || args.containsKey("l") || args.containsKey("r") || args.containsKey("b")) {
                return new MarginBorder(this.makeInt(args, "t", 0), this.makeInt(args, "l", 0), this.makeInt(args, "b", 0), this.makeInt(args, "r", 0));
            }
            return new MarginBorder(0);
        }
        if (border.startsWith("COMPOUND:")) {
            Map<String, String> args = this.parseBorderArguments("", border.substring("COMPOUND:".length()));
            return new CompoundBorder(this.makeBorder(args.get("outer")), this.makeBorder(args.get("inner")));
        }
        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.scada.vi.ui.draw2d", "Invalid border string: " + border), 1);
        return null;
    }

    private int makeInt(Map<String, String> args, String string, int defaultValue) {
        String value = args.get(string);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    protected Map<String, String> parseBorderArguments(String singleArgumentName, String border) {
        if (border == null || border.isEmpty()) {
            return Collections.emptyMap();
        }
        if (border.startsWith("[") && border.endsWith("]")) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            String str = border.substring(1, border.length() - 1);
            String[] stringArray = str.split("[, \\t\\n\\r]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tok = stringArray[n2];
                String[] ele = tok.split("=", 2);
                if (ele.length > 1) {
                    result.put(ele[0], ele[1]);
                }
                ++n2;
            }
            return result;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(1);
        result.put(singleArgumentName, border);
        return result;
    }

    protected Dimension create(org.eclipse.scada.vi.model.Dimension dimension) {
        if (dimension == null) {
            return null;
        }
        return new PrecisionDimension(dimension.getWidth(), dimension.getHeight());
    }

    protected ColorHandler makeColorHandler(String color, ColorApplier applier) {
        if (color == null) {
            return new DefaultColor(this.getPropertyFigure(), applier);
        }
        if (color.startsWith("#") && !color.contains("|")) {
            return new StaticColor(this.getPropertyFigure(), applier, this.createColor(Helper.makeColor(color)));
        }
        if ((color.startsWith("#") || color.startsWith("|")) && color.contains("|")) {
            String[] tok = color.split("\\|", -1);
            Color[] colors = new Color[tok.length];
            int i = 0;
            String[] stringArray = tok;
            int n = tok.length;
            int n2 = 0;
            while (n2 < n) {
                String colorString = stringArray[n2];
                colors[i] = this.createColor(Helper.makeColor(colorString));
                ++i;
                ++n2;
            }
            return new BlinkingColor(this.getPropertyFigure(), applier, colors);
        }
        return new DefaultColor(this.getPropertyFigure(), applier);
    }

    protected Color createColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return this.manager.createColor(rgb);
    }

    private static class BackgroundApplier
    implements ColorApplier {
        private BackgroundApplier() {
        }

        @Override
        public void applyColor(IFigure figure, Color color) {
            figure.setBackgroundColor(color);
        }
    }

    private static class BlinkingColor
    extends AbstractBlinker
    implements ColorHandler {
        private final IFigure figure;
        private final ColorApplier applier;
        private final Color[] colors;

        public BlinkingColor(IFigure figure, ColorApplier applier, Color[] colors) {
            this.figure = figure;
            this.applier = applier;
            this.colors = colors;
        }

        @Override
        public void start() {
            this.enableBlinking(true);
        }

        @Override
        public void stop() {
            this.enableBlinking(false);
            super.dispose();
        }

        public void toggle(int globalCounter) {
            if (this.colors == null || this.colors.length == 0) {
                this.applier.applyColor(this.figure, null);
            } else {
                this.applier.applyColor(this.figure, this.colors[globalCounter % this.colors.length]);
            }
        }
    }

    public class ClickHandlerImpl
    extends MouseListener.Stub {
        public void mouseReleased(MouseEvent me) {
            FigureController.this.handleOnClick(me);
        }

        public void mouseDoubleClicked(MouseEvent me) {
            FigureController.this.handleOnDoubleClick(me);
        }
    }

    private static interface ColorApplier {
        public void applyColor(IFigure var1, Color var2);
    }

    private static interface ColorHandler {
        public void start();

        public void stop();
    }

    private static class DefaultColor
    implements ColorHandler {
        private final IFigure figure;
        private final ColorApplier applier;

        public DefaultColor(IFigure figure, ColorApplier applier) {
            this.figure = figure;
            this.applier = applier;
        }

        @Override
        public void start() {
            this.applier.applyColor(this.figure, null);
        }

        @Override
        public void stop() {
        }
    }

    private static class ForegroundApplier
    implements ColorApplier {
        private ForegroundApplier() {
        }

        @Override
        public void applyColor(IFigure figure, Color color) {
            figure.setForegroundColor(color);
        }
    }

    public static enum SWTCursors {
        ARROW(0),
        HAND(21),
        HELP(4),
        WAIT(1),
        CROSS(2),
        IBEAM(19),
        NO(20);

        private int id;

        private SWTCursors(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }

    private static class StaticColor
    implements ColorHandler {
        private final IFigure figure;
        private final ColorApplier applier;
        private final Color color;

        public StaticColor(IFigure figure, ColorApplier applier, Color color) {
            this.figure = figure;
            this.applier = applier;
            this.color = color;
        }

        @Override
        public void start() {
            this.applier.applyColor(this.figure, this.color);
        }

        @Override
        public void stop() {
        }
    }
}

