/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.ngp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.stats.StatisticsImpl;

public class CallbackHandlerManager {
    private static final Object STAT_REGISTERED_CALLBACK_HANDLERS = new Object();
    private final Map<Long, CallbackHandler> map = new HashMap<Long, CallbackHandler>();
    private final StatisticsImpl statistics;

    public CallbackHandlerManager(StatisticsImpl statistics) {
        this.statistics = statistics;
        this.statistics.setLabel(STAT_REGISTERED_CALLBACK_HANDLERS, "Registered callback handlers");
    }

    public void registerHandler(long handlerId, CallbackHandler callbackHandler) {
        this.map.put(handlerId, callbackHandler);
        this.statistics.setCurrentValue(STAT_REGISTERED_CALLBACK_HANDLERS, (double)this.map.size());
    }

    public void unregisterHandler(long handlerId) {
        this.map.remove(handlerId);
        this.statistics.setCurrentValue(STAT_REGISTERED_CALLBACK_HANDLERS, (double)this.map.size());
    }

    public CallbackHandler getHandler(long handlerId) {
        return this.map.get(handlerId);
    }
}

