/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.callback;

import java.util.Map;
import java.util.Properties;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.PasswordCallback;
import org.eclipse.scada.sec.callback.UserNameCallback;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesCredentialsCallback
implements CallbackHandler {
    private static final String PROP_USER = "user";
    private static final String PROP_PASSWORD = "password";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesCredentialsCallback.class);
    private final Properties props;

    public PropertiesCredentialsCallback(String username, String password) {
        this.props = new Properties();
        this.props.put(PROP_USER, username);
        this.props.put(PROP_PASSWORD, password);
    }

    public PropertiesCredentialsCallback(Properties props) {
        this.props = props;
    }

    public PropertiesCredentialsCallback(Map<String, String> properties) {
        this.props = new Properties();
        this.props.putAll(properties);
    }

    @Override
    public NotifyFuture<Callback[]> performCallback(Callback[] callbacks) {
        logger.debug("Processing callbacks based on properties");
        Callback[] callbackArray = callbacks;
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback cb = callbackArray[n2];
            logger.debug("Processing callback: {}", (Object)cb);
            if (cb instanceof PasswordCallback && this.props.containsKey(PROP_PASSWORD)) {
                logger.debug("Answering password: ***");
                ((PasswordCallback)cb).setPassword(this.props.getProperty(PROP_PASSWORD));
            } else if (cb instanceof UserNameCallback && this.props.containsKey(PROP_USER)) {
                logger.debug("Answering user: {}", (Object)this.props.getProperty(PROP_USER));
                ((UserNameCallback)cb).setValue(this.props.getProperty(PROP_USER));
            } else {
                logger.debug("Cancel callback");
                cb.cancel();
            }
            ++n2;
        }
        return new InstantFuture((Object)callbacks);
    }
}

