/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.Helper;
import org.eclipse.scada.chart.swt.render.AbstractRenderer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class XAxisDynamicRenderer
extends AbstractRenderer {
    protected PropertyChangeListener propertyChangeListener;
    protected final LineAttributes lineAttributes;
    protected int labelSpacing;
    private XAxis axis;
    private boolean bottom = true;
    private Long step;
    private String format = "%tc";
    private int height = -1;
    private Rectangle rect;
    private final int markerSize = 5;
    private int textPadding = 5;
    private final ChartRenderer chart;
    private boolean showLabels;
    private final int markerSpacing = 0;

    public XAxisDynamicRenderer(ChartRenderer chart) {
        super(chart);
        this.chart = chart;
        this.lineAttributes = new LineAttributes(1.0f, 1, 3, 1, new float[0], 0.0f, 0.0f);
        this.labelSpacing = 20;
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                XAxisDynamicRenderer.this.handlePropertyChange(evt);
            }
        };
    }

    protected void handlePropertyChange(PropertyChangeEvent evt) {
        this.redraw();
    }

    public void setAlign(int alignment) {
        this.bottom = (alignment & 0x80) != 128;
        this.redraw();
    }

    public void setHeight(int height) {
        this.height = height;
        this.redraw();
    }

    public void setFormat(String format) {
        this.format = format;
        this.redraw();
    }

    public String getFormat() {
        return this.format;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.redraw();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public int getHeight() {
        return this.height;
    }

    public void setTextPadding(int textPadding) {
        this.textPadding = textPadding;
    }

    public int getTextPadding() {
        return this.textPadding;
    }

    public void setStep(Long step) {
        this.step = step;
        this.redraw();
    }

    public Long getStep() {
        return this.step;
    }

    @Override
    public void dispose() {
        this.setAxis(null);
        super.dispose();
    }

    public void setAxis(XAxis axis) {
        if (this.axis != null) {
            this.axis.removePropertyChangeListener(this.propertyChangeListener);
            this.axis = null;
        }
        this.axis = axis;
        if (this.axis != null) {
            this.axis.addPropertyChangeListener(this.propertyChangeListener);
            this.redraw();
        }
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        if (this.rect.width == 0 || this.rect.height == 0) {
            return;
        }
        g.setLineAttributes(this.lineAttributes);
        int y = this.bottom ? this.rect.y : this.rect.y + this.rect.height;
        Rectangle chartRect = this.chart.getClientAreaProxy().getClientRectangle();
        String label = this.axis.getLabel();
        if (label != null) {
            Point size = g.textExtent(label);
            int labelX = this.rect.x + this.rect.width / 2 - size.x / 2;
            g.drawText(label, labelX, this.bottom ? this.rect.y + this.rect.height - (size.y + this.textPadding) : this.rect.y + this.textPadding, null);
        }
        g.drawLine(chartRect.x, y + (this.bottom ? 0 : -1), chartRect.x + chartRect.width, y + (this.bottom ? 0 : -1));
        DateFormat format = this.makeFormat(this.axis.getMax() - this.axis.getMin());
        Point sampleLabelSize = g.textExtent(format.format(new Date()));
        List<Helper.Entry<Long>> markers = Helper.chartTimes(this.axis.getMin(), this.axis.getMax(), chartRect.width, (int)Math.round(1.5 * (double)sampleLabelSize.x) + 0, format);
        for (Helper.Entry<Long> marker : markers) {
            int x = chartRect.x + marker.position;
            g.drawText(marker.label, x, this.bottom ? this.rect.y + 5 + this.textPadding : this.rect.y + this.rect.height - (sampleLabelSize.y + this.textPadding), null);
            g.drawLine(x, y, x, this.bottom ? y + 5 : y - 5);
        }
    }

    @Override
    public Rectangle resize(Rectangle clientRectangle) {
        int height;
        int n = height = this.height >= 0 ? this.height : this.calcHeight();
        if (this.bottom) {
            this.rect = new Rectangle(clientRectangle.x, clientRectangle.y + clientRectangle.height - height, clientRectangle.width, height);
            return new Rectangle(clientRectangle.x, clientRectangle.y, clientRectangle.width, clientRectangle.height - height);
        }
        this.rect = new Rectangle(clientRectangle.x, clientRectangle.y, clientRectangle.width, height);
        return new Rectangle(clientRectangle.x, clientRectangle.y + height, clientRectangle.width, clientRectangle.height - height);
    }

    private DateFormat makeFormat(long timeRange) {
        if (this.format != null && !this.format.isEmpty()) {
            try {
                return new SimpleDateFormat(this.format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return DateFormat.getInstance();
            }
        }
        return Helper.makeFormat(timeRange);
    }

    private int calcHeight() {
        GC gc = new GC((Drawable)Display.getCurrent());
        try {
            DateFormat format = this.makeFormat(this.axis.getMax() - this.axis.getMin());
            Point markerSize = this.getExtent(gc, format.format(new Date()));
            Point labelSize = this.getExtent(gc, this.axis.getLabel());
            int height = markerSize.y + labelSize.y + this.textPadding * 2 + 5;
            if (labelSize.y > 0) {
                height += this.textPadding;
            }
            int n = height;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private Point getExtent(GC gc, String string) {
        if (string == null || string.isEmpty()) {
            return new Point(0, 0);
        }
        return gc.textExtent(string);
    }
}

