/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.ConnectionDiscoverer;
import org.eclipse.scada.core.ui.connection.ConnectionDiscoveryListener;

public abstract class AbstractConnectionDiscoverer
implements ConnectionDiscoverer {
    private final Set<ConnectionDiscoveryListener> listeners = new HashSet<ConnectionDiscoveryListener>();
    private Set<ConnectionDescriptor> connections = new HashSet<ConnectionDescriptor>();

    protected synchronized void setConnections(Set<ConnectionDescriptor> result) {
        HashSet<ConnectionDescriptor> added = new HashSet<ConnectionDescriptor>(result);
        added.removeAll(this.connections);
        HashSet<ConnectionDescriptor> removed = new HashSet<ConnectionDescriptor>(this.connections);
        removed.removeAll(result);
        this.connections = result;
        this.fireDiscoveryUpdate(added.toArray(new ConnectionDescriptor[added.size()]), removed.toArray(new ConnectionDescriptor[removed.size()]));
    }

    protected synchronized void fireDiscoveryUpdate(ConnectionDescriptor[] added, ConnectionDescriptor[] removed) {
        for (ConnectionDiscoveryListener listener : this.listeners) {
            listener.discoveryUpdate(added, removed);
        }
    }

    @Override
    public synchronized void addConnectionListener(ConnectionDiscoveryListener listener) {
        if (this.listeners.add(listener)) {
            listener.discoveryUpdate(this.connections.toArray(new ConnectionDescriptor[this.connections.size()]), null);
        }
    }

    @Override
    public synchronized void removeConnectionListener(ConnectionDiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized boolean addConnection(ConnectionDescriptor connectionInformation) {
        if (connectionInformation == null) {
            return false;
        }
        if (this.connections.add(connectionInformation)) {
            this.fireDiscoveryUpdate(new ConnectionDescriptor[]{connectionInformation}, null);
            return true;
        }
        return false;
    }

    protected synchronized boolean removeConnection(ConnectionDescriptor connectionInformation) {
        if (connectionInformation == null) {
            return false;
        }
        if (this.connections.remove(connectionInformation)) {
            this.fireDiscoveryUpdate(null, new ConnectionDescriptor[]{connectionInformation});
            return true;
        }
        return false;
    }

    public Set<ConnectionDescriptor> getConnections() {
        return Collections.unmodifiableSet(this.connections);
    }

    public synchronized void dispose() {
        this.fireDiscoveryUpdate(null, this.connections.toArray(new ConnectionDescriptor[this.connections.size()]));
        this.listeners.clear();
        this.connections.clear();
    }
}

