/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.ngp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.NoConnectionException;
import org.eclipse.scada.core.client.ngp.ConnectionBaseImpl;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.data.RequestMessage;
import org.eclipse.scada.core.data.ResponseMessage;
import org.eclipse.scada.core.data.UserInformation;
import org.eclipse.scada.da.client.BrowseOperationCallback;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.client.Helper;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.client.WriteAttributeOperationCallback;
import org.eclipse.scada.da.client.WriteOperationCallback;
import org.eclipse.scada.da.client.ngp.DriverFactoryImpl;
import org.eclipse.scada.da.common.ngp.ProtocolConfigurationFactoryImpl;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.data.AttributeWriteResultEntry;
import org.eclipse.scada.da.data.BrowserEntry;
import org.eclipse.scada.da.data.message.BrowseFolder;
import org.eclipse.scada.da.data.message.BrowseResult;
import org.eclipse.scada.da.data.message.FolderDataUpdate;
import org.eclipse.scada.da.data.message.ItemDataUpdate;
import org.eclipse.scada.da.data.message.ItemStateUpdate;
import org.eclipse.scada.da.data.message.StartWriteAttributes;
import org.eclipse.scada.da.data.message.StartWriteValue;
import org.eclipse.scada.da.data.message.SubscribeFolder;
import org.eclipse.scada.da.data.message.SubscribeItem;
import org.eclipse.scada.da.data.message.UnsubscibeItem;
import org.eclipse.scada.da.data.message.UnsubscribeFolder;
import org.eclipse.scada.da.data.message.WriteAttributesResult;
import org.eclipse.scada.da.data.message.WriteValueResult;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.ExecutorFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends ConnectionBaseImpl
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionImpl.class);
    private final Map<String, ItemUpdateListener> itemListeners = new HashMap<String, ItemUpdateListener>();
    private final Map<Location, FolderListener> folderListeners = new HashMap<Location, FolderListener>();

    static {
        DriverFactoryImpl.registerDriver();
    }

    public ConnectionImpl(ConnectionInformation connectionInformation) throws Exception {
        super((ProtocolConfigurationFactory)new ProtocolConfigurationFactoryImpl(connectionInformation), connectionInformation);
    }

    public static WriteAttributeResults convertResults(List<AttributeWriteResultEntry> attributeResults) {
        WriteAttributeResults result = new WriteAttributeResults();
        for (AttributeWriteResultEntry entry : attributeResults) {
            result.put((Object)entry.getAttribute(), (Object)ConnectionImpl.convertResult(entry.getErrorInformation()));
        }
        return result;
    }

    private static WriteAttributeResult convertResult(ErrorInformation errorInformation) {
        if (errorInformation == null) {
            return WriteAttributeResult.OK;
        }
        return new WriteAttributeResult(new OperationException(errorInformation.getMessage()).fillInStackTrace());
    }

    public synchronized void browse(Location location, final BrowseOperationCallback callback) {
        NotifyFuture<Entry[]> future = this.browse(location);
        if (callback != null) {
            future.addListener((FutureListener)new FutureListener<Entry[]>(){

                public void complete(Future<Entry[]> future) {
                    try {
                        callback.complete(future.get());
                    }
                    catch (Exception e) {
                        callback.error((Throwable)e);
                    }
                }
            });
        }
    }

    public synchronized NotifyFuture<Entry[]> browse(Location location) {
        return new BrowseFuture(this.executor, (NotifyFuture<ResponseMessage>)this.sendRequestMessage((RequestMessage)new BrowseFolder(this.nextRequest(), location.asList())));
    }

    public void write(String itemId, Variant value, OperationParameters operationParameters, WriteOperationCallback callback) {
        NotifyFuture<WriteResult> future = this.startWrite(itemId, value, operationParameters, null);
        Helper.transformWrite(future, (WriteOperationCallback)callback);
    }

    public synchronized NotifyFuture<WriteResult> startWrite(String itemId, Variant value, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        Request request = this.nextRequest();
        Long callbackHandlerId = this.registerCallbackHandler(request, callbackHandler);
        return new WriteFuture(this.executor, (NotifyFuture<ResponseMessage>)this.sendRequestMessage((RequestMessage)new StartWriteValue(request, itemId, value, ConnectionImpl.makeParameters(operationParameters), callbackHandlerId)));
    }

    public void writeAttributes(String itemId, Map<String, Variant> attributes, OperationParameters operationParameters, WriteAttributeOperationCallback callback) {
        NotifyFuture<WriteAttributeResults> future = this.startWriteAttributes(itemId, attributes, operationParameters, null);
        Helper.transformWriteAttributes((WriteAttributeOperationCallback)callback, future);
    }

    public synchronized NotifyFuture<WriteAttributeResults> startWriteAttributes(String itemId, Map<String, Variant> attributes, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        Request request = this.nextRequest();
        Long callbackHandlerId = this.registerCallbackHandler(request, callbackHandler);
        return new WriteAttributesFuture(this.executor, (NotifyFuture<ResponseMessage>)this.sendRequestMessage((RequestMessage)new StartWriteAttributes(this.nextRequest(), itemId, attributes, ConnectionImpl.makeParameters(operationParameters), callbackHandlerId)));
    }

    public void subscribeFolder(Location location) throws NoConnectionException, OperationException {
        this.sendMessage(new SubscribeFolder(location.asList()));
    }

    public void unsubscribeFolder(Location location) throws NoConnectionException, OperationException {
        this.sendMessage(new UnsubscribeFolder(location.asList()));
    }

    public synchronized FolderListener setFolderListener(Location location, FolderListener listener) {
        return this.folderListeners.put(location, listener);
    }

    public void subscribeItem(String itemId) throws NoConnectionException, OperationException {
        logger.debug("Subscribe item: {}", (Object)itemId);
        this.sendMessage(new SubscribeItem(itemId));
    }

    public void unsubscribeItem(String itemId) throws NoConnectionException, OperationException {
        this.sendMessage(new UnsubscibeItem(itemId));
    }

    public synchronized ItemUpdateListener setItemUpdateListener(String itemId, ItemUpdateListener listener) {
        return this.itemListeners.put(itemId, listener);
    }

    protected synchronized void handleMessage(Object message) {
        if (message instanceof ItemDataUpdate) {
            this.handleItemDataUpdate((ItemDataUpdate)message);
        } else if (message instanceof FolderDataUpdate) {
            this.handleFolderDataUpdate((FolderDataUpdate)message);
        } else if (message instanceof ItemStateUpdate) {
            this.handleItemStateUpdate((ItemStateUpdate)message);
        } else {
            super.handleMessage(message);
        }
    }

    private void handleFolderDataUpdate(final FolderDataUpdate message) {
        final FolderListener listener = this.folderListeners.get(new Location(message.getLocation()));
        if (listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.folderChanged(ConnectionImpl.this.convert(message.getAddedOrModified()), (Collection)message.getRemoved(), message.isFull());
                }
            });
        }
    }

    private void handleItemDataUpdate(final ItemDataUpdate message) {
        final ItemUpdateListener listener = this.itemListeners.get(message.getItemId());
        if (listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifyDataChange(message.getValue(), ConnectionImpl.makeAttributes(message.getAddedOrUpdated(), message.getRemoved()), message.isCacheValue());
                }
            });
        }
    }

    private void handleItemStateUpdate(final ItemStateUpdate message) {
        final ItemUpdateListener listener = this.itemListeners.get(message.getItemId());
        if (listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifySubscriptionChange(message.getSubscriptionState(), null);
                }
            });
        }
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    protected static Map<String, Variant> makeAttributes(Map<String, Variant> addedOrUpdated, Set<String> removed) {
        int addedOrUpdatedSize = addedOrUpdated != null ? addedOrUpdated.size() : 0;
        int removedSize = removed != null ? removed.size() : 0;
        HashMap<String, Variant> result = new HashMap<String, Variant>(addedOrUpdatedSize + removedSize);
        if (addedOrUpdated != null) {
            result.putAll(addedOrUpdated);
        }
        if (removed != null) {
            for (String itemId : removed) {
                result.put(itemId, null);
            }
        }
        return result;
    }

    protected Collection<Entry> convert(List<BrowserEntry> addedOrModified) {
        return Arrays.asList(org.eclipse.scada.da.client.ngp.internal.Helper.convert(addedOrModified));
    }

    protected static OperationParameters makeParameters(OperationParameters operationParameters) {
        if (operationParameters == null) {
            return null;
        }
        HashMap properties = new HashMap(0);
        UserInformation userInformation = null;
        if (operationParameters.getUserInformation() != null) {
            userInformation = new UserInformation(operationParameters.getUserInformation().getName());
        }
        return new OperationParameters(userInformation, properties);
    }

    public static class BrowseFuture
    extends ExecutorFuture<Entry[]>
    implements FutureListener<ResponseMessage> {
        public BrowseFuture(Executor executor, NotifyFuture<ResponseMessage> future) {
            super(executor);
            future.addListener((FutureListener)this);
        }

        public void complete(Future<ResponseMessage> future) {
            try {
                ResponseMessage response = future.get();
                if (response instanceof BrowseResult) {
                    if (((BrowseResult)response).getErrorInformation() == null) {
                        this.setResult(org.eclipse.scada.da.client.ngp.internal.Helper.convert(((BrowseResult)response).getBrowserData()));
                    } else {
                        this.setError(new OperationException(((BrowseResult)response).getErrorInformation().getMessage()).fillInStackTrace());
                    }
                } else {
                    this.setError(new IllegalStateException(String.format("Wrong reply - expected: %s, got: %s", BrowseResult.class, response)));
                }
            }
            catch (Exception e) {
                this.setError(e);
            }
        }
    }

    public static class WriteAttributesFuture
    extends ExecutorFuture<WriteAttributeResults>
    implements FutureListener<ResponseMessage> {
        public WriteAttributesFuture(Executor executor, NotifyFuture<ResponseMessage> future) {
            super(executor);
            future.addListener((FutureListener)this);
        }

        public void complete(Future<ResponseMessage> future) {
            try {
                ResponseMessage response = future.get();
                if (response instanceof WriteAttributesResult) {
                    if (((WriteAttributesResult)response).getErrorInformation() == null) {
                        this.setResult(ConnectionImpl.convertResults(((WriteAttributesResult)response).getAttributeResults()));
                    } else {
                        this.setError(new OperationException(((WriteAttributesResult)response).getErrorInformation().getMessage()).fillInStackTrace());
                    }
                } else {
                    this.setError(new IllegalStateException(String.format("Wrong reply - expected: %s, got: %s", WriteAttributesResult.class, response)));
                }
            }
            catch (Exception e) {
                this.setError(e);
            }
        }
    }

    public static class WriteFuture
    extends ExecutorFuture<WriteResult>
    implements FutureListener<ResponseMessage> {
        public WriteFuture(Executor executor, NotifyFuture<ResponseMessage> future) {
            super(executor);
            future.addListener((FutureListener)this);
        }

        public void complete(Future<ResponseMessage> future) {
            try {
                ResponseMessage response = future.get();
                if (response instanceof WriteValueResult) {
                    if (((WriteValueResult)response).getErrorInformation() == null) {
                        this.setResult(WriteResult.OK);
                    } else {
                        this.setError(new OperationException(((WriteValueResult)response).getErrorInformation().getMessage()).fillInStackTrace());
                    }
                } else {
                    this.setError(new IllegalStateException(String.format("Wrong reply - expected: %s, got: %s", WriteValueResult.class, response)));
                }
            }
            catch (Exception e) {
                this.setError(e);
            }
        }
    }
}

