/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client;

import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectWaitController
implements ConnectionStateListener {
    private static final Logger logger = LoggerFactory.getLogger(ConnectWaitController.class);
    private final Connection connection;
    private ConnectionState state;
    private Throwable error;

    public ConnectWaitController(Connection connection) {
        this.connection = connection;
    }

    public synchronized void connect() throws Exception {
        this.connect(0);
    }

    public synchronized void connect(int timeout) throws Exception {
        try {
            this.state = this.connection.getState();
            this.connection.addConnectionStateListener(this);
            this.connection.connect();
            switch (this.state) {
                case BOUND: {
                    return;
                }
                case CLOSED: {
                    if (this.error == null) {
                        return;
                    }
                    throw new Exception(this.error);
                }
            }
            this.wait(timeout);
            if (this.error != null) {
                throw new Exception(this.error);
            }
        }
        finally {
            this.connection.removeConnectionStateListener(this);
        }
    }

    @Override
    public synchronized void stateChange(Connection connection, ConnectionState state, Throwable error) {
        logger.info(String.format("New connection state: %s", new Object[]{state}));
        this.state = state;
        this.error = error;
        switch (state) {
            case BOUND: {
                this.notifyAll();
                break;
            }
            case CLOSED: {
                this.notifyAll();
                break;
            }
        }
    }
}

