/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;
import org.eclipse.scada.da.ui.widgets.realtime.Messages;
import org.eclipse.scada.da.ui.widgets.realtime.RealtimeListAdapter;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class RemoveAction
extends Action
implements ISelectionChangedListener,
IEditorActionDelegate {
    private RealtimeListAdapter view = null;
    private Collection<ListEntry> entries;

    public RemoveAction(RealtimeListAdapter view) {
        super(Messages.RemoveAction_Name, 1);
        this.view = view;
    }

    public void run() {
        if (this.entries == null || this.view == null) {
            return;
        }
        this.view.remove(this.entries);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof RealtimeListAdapter) {
            this.view = (RealtimeListAdapter)targetEditor;
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
    }

    private void setSelection(ISelection selection) {
        this.entries = new LinkedList<ListEntry>();
        if (selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                if (!(o instanceof ListEntry)) continue;
                this.entries.add((ListEntry)o);
            }
        }
    }
}

