/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import org.eclipse.scada.chart.AbstractSeriesData;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.SeriesDataListener;
import org.eclipse.scada.chart.SeriesViewData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.hd.ui.data.ServiceQueryBuffer;
import org.eclipse.scada.ui.chart.viewer.input.QuerySeriesData;

public class QueryChannelSeriesData
extends AbstractSeriesData {
    private final QuerySeriesData masterData;
    private String channelName;
    private final SeriesDataListener listener = new SeriesDataListener(){

        public void dataUpdate(long startTimestamp, long endTimestamp) {
            QueryChannelSeriesData.this.handleUpdate(startTimestamp, endTimestamp);
        }
    };

    public QueryChannelSeriesData(Realm realm, XAxis xAxis, YAxis yAxis, QuerySeriesData masterData, String channelName) {
        super(realm, xAxis, yAxis);
        this.masterData = masterData;
        this.channelName = channelName;
        masterData.addListener(this.listener);
    }

    public void dispose() {
        this.masterData.removeListener(this.listener);
        super.dispose();
    }

    public ServiceQueryBuffer getQuery() {
        return this.masterData.getQuery();
    }

    protected void handleUpdate(long startTimestamp, long endTimestamp) {
        this.fireUpdateListener(startTimestamp, endTimestamp);
    }

    public void setRequestWindow(long startTimestamp, long endTimestamp) {
    }

    public void setRequestWidth(int width) {
    }

    public SeriesViewData getViewData() {
        return this.masterData.getViewData(this.channelName);
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
        this.fireUpdateListener(0L, Long.MAX_VALUE);
    }
}

