/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.ngp;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.client.ngp.ConnectionImpl;
import org.eclipse.scada.ae.data.QueryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static final Logger logger = LoggerFactory.getLogger(QueryImpl.class);
    private final long queryId;
    private QueryListener listener;
    private final ConnectionImpl connection;
    private final ExecutorService executor;

    public QueryImpl(ExecutorService executor, ConnectionImpl connection, long queryId, QueryListener listener) {
        this.executor = executor;
        this.connection = connection;
        this.queryId = queryId;
        this.listener = listener;
    }

    public void close() {
        logger.debug("Requesting close: {}", (Object)this.queryId);
        this.connection.sendCloseQuery(this.queryId);
    }

    public void loadMore(int count) {
        logger.debug("Request to load more: {}", (Object)count);
        if (count <= 0) {
            throw new IllegalArgumentException("'count' must be greater than zero");
        }
        this.connection.sendLoadMore(this.queryId, count);
    }

    public void handleStateChange(final QueryListener listener, final QueryState state, final Throwable error) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.queryStateChanged(state, error);
                }
            }
        });
    }

    public void dispose() {
        logger.debug("Disposing query: {}", (Object)this.queryId);
        if (this.listener != null) {
            this.handleStateChange(this.listener, QueryState.DISCONNECTED, null);
            this.listener = null;
        }
    }

    public void handleData(final QueryListener listener, final List<Event> data) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.queryData(data);
                }
            }
        });
    }

    public QueryListener getListener() {
        return this.listener;
    }
}

