/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.browser.Entry;

public class FolderWatcher
extends Observable
implements FolderListener {
    protected Location location = null;
    protected Map<String, Entry> cache = new HashMap<String, Entry>();

    public FolderWatcher(String ... path) {
        this.location = new Location(path);
    }

    public FolderWatcher(Location location) {
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void folderChanged(Collection<Entry> added, Collection<String> removed, boolean full) {
        int changed = 0;
        FolderWatcher folderWatcher = this;
        synchronized (folderWatcher) {
            if (full) {
                this.cache.clear();
            }
            for (Entry entry : added) {
                this.cache.put(entry.getName(), entry);
                ++changed;
            }
            for (String name : removed) {
                if (this.cache.remove(name) == null) continue;
                ++changed;
            }
            if (changed > 0 || full) {
                this.setChanged();
            }
        }
        this.notifyObservers();
    }

    public Location getLocation() {
        return this.location;
    }

    public Map<String, Entry> getCache() {
        return this.cache;
    }

    public Collection<Entry> getList() {
        return this.cache.values();
    }
}

