/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.ui.connection.internal.FolderEntryWrapper;
import org.eclipse.scada.da.ui.connection.views.FolderObserver;

public class RootFolderObserver
extends FolderObserver
implements PropertyChangeListener {
    final ConnectionHolder connectionHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootFolderObserver(ConnectionHolder connectionHolder) {
        this.connectionHolder = connectionHolder;
        RootFolderObserver rootFolderObserver = this;
        synchronized (rootFolderObserver) {
            connectionHolder.addPropertyChangeListener("connectionService", (PropertyChangeListener)this);
            this.updateConnection();
        }
    }

    @Override
    public synchronized void dispose() {
        this.connectionHolder.removePropertyChangeListener("connectionService", (PropertyChangeListener)this);
        this.setFolderManager(null);
        super.dispose();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.updateConnection();
    }

    private void updateConnection() {
        org.eclipse.scada.core.connection.provider.ConnectionService connection = this.connectionHolder.getConnectionService();
        if (connection == null) {
            this.setConnection(null);
        } else if (connection instanceof ConnectionService) {
            this.setConnection((ConnectionService)connection);
        }
    }

    private synchronized void setConnection(ConnectionService connectionService) {
        if (connectionService != null) {
            this.setFolderManager(new FolderEntryWrapper(this.connectionHolder, connectionService.getFolderManager()));
        } else {
            this.data.clear();
        }
    }
}

