/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart;

import org.eclipse.scada.chart.AbstractSeriesData;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.WritableSeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFunctionSeriesData
extends AbstractSeriesData {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFunctionSeriesData.class);
    protected Request request;

    public AbstractFunctionSeriesData(Realm realm, XAxis xAxis, YAxis yAxis) {
        super(realm, xAxis, yAxis);
    }

    protected WritableSeriesData makeData(Request request) {
        WritableSeriesData result = new WritableSeriesData();
        long startTimestamp = request.getStart();
        long endTimestamp = request.getEnd();
        double step = (double)(endTimestamp - startTimestamp) / (double)request.getWidth();
        double i = startTimestamp;
        while (i < (double)endTimestamp) {
            long tx = (long)i;
            result.add(new DataEntry(tx, this.eval(tx)));
            i += step;
        }
        return result;
    }

    protected abstract Double eval(long var1);

    @Override
    public void setRequestWidth(int width) {
        Request request = this.request;
        this.setRequest(new Request(request.getStart(), request.getEnd(), width));
    }

    @Override
    public void setRequestWindow(long startTimestamp, long endTimestamp) {
        Request request = this.request;
        this.setRequest(new Request(startTimestamp, endTimestamp, request.getWidth()));
    }

    protected void setRequest(Request request) {
        logger.debug("Setting request: {}", (Object)request);
        this.request = request;
    }

    protected static final class Request {
        private final long start;
        private final long end;
        private final int width;

        public Request(long start, long end, int width) {
            this.start = start;
            this.end = end;
            this.width = width;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public int getWidth() {
            return this.width;
        }

        public String toString() {
            return String.format("%s - >%s #%s", this.start, this.end, this.width);
        }
    }
}

