/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.SeriesDataListener;
import org.eclipse.scada.chart.SeriesViewData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSeriesData
implements SeriesData {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSeriesData.class);
    private final XAxis xAxis;
    private final YAxis yAxis;
    private final PropertyChangeListener listener;
    private final Set<SeriesDataListener> listeners = new HashSet<SeriesDataListener>();
    private final Realm realm;

    public AbstractSeriesData(Realm realm, XAxis xAxis, YAxis yAxis) {
        this.realm = realm;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractSeriesData.this.handlePropertyChange(evt);
            }
        };
        xAxis.addPropertyChangeListener(this.listener);
    }

    @Override
    public void addListener(SeriesDataListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SeriesDataListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireUpdateListener(final long startTimestamp, final long endTimestamp) {
        this.realm.asyncExec(new Runnable(){

            @Override
            public void run() {
                logger.trace("Process update listener - start: {}, end: {}", (Object)startTimestamp, (Object)endTimestamp);
                for (SeriesDataListener listener : AbstractSeriesData.this.listeners) {
                    listener.dataUpdate(startTimestamp, endTimestamp);
                }
            }
        });
    }

    protected void handlePropertyChange(PropertyChangeEvent evt) {
        this.setRequestWindow(this.xAxis.getMin(), this.xAxis.getMax());
    }

    public void dispose() {
        this.xAxis.removePropertyChangeListener(this.listener);
    }

    @Override
    public XAxis getXAxis() {
        return this.xAxis;
    }

    @Override
    public YAxis getYAxis() {
        return this.yAxis;
    }

    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public abstract void setRequestWindow(long var1, long var3);

    @Override
    public abstract void setRequestWidth(int var1);

    @Override
    public abstract SeriesViewData getViewData();
}

