/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.protocol.ngp.codec.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDataUpdate
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(ItemDataUpdate.class);
    public static final int MESSAGE_CODE = 4099;

    public int getMessageCode() {
        return 4099;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.da.data.message.ItemDataUpdate.class;
    }

    public org.eclipse.scada.da.data.message.ItemDataUpdate decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 4099) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 4099, messageCode));
        }
        int numberOfFields = _data.get();
        String itemId = null;
        Variant value = null;
        Map addedOrUpdated = null;
        Set removed = null;
        boolean cacheValue = false;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    itemId = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    value = _context.decodeVariant(_data);
                    break;
                }
                case 3: {
                    addedOrUpdated = _context.decodeVariantMap(_data);
                    break;
                }
                case 4: {
                    removed = _context.decodeStringSet(_data);
                    break;
                }
                case 5: {
                    cacheValue = _context.decodePrimitiveBoolean(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.da.data.message.ItemDataUpdate(itemId, value, addedOrUpdated, removed, cacheValue);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.da.data.message.ItemDataUpdate value = (org.eclipse.scada.da.data.message.ItemDataUpdate)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(4099);
        data.put((byte)5);
        context.encodeString(data, (byte)1, value.getItemId());
        context.encodeVariant(data, (byte)2, value.getValue());
        context.encodeVariantMap(data, (byte)3, value.getAddedOrUpdated());
        context.encodeStringCollection(data, (byte)4, (Collection)value.getRemoved());
        context.encodePrimitiveBoolean(data, (byte)5, value.isCacheValue());
        data.flip();
        return data;
    }
}

