/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common;

import javax.net.ssl.SSLContext;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.compression.CompressionFilter;
import org.apache.mina.filter.keepalive.KeepAliveFilter;
import org.apache.mina.filter.keepalive.KeepAliveMessageFactory;
import org.apache.mina.filter.keepalive.KeepAliveRequestTimeoutHandler;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.apache.mina.filter.ssl.SslFilter;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfiguration;
import org.eclipse.scada.protocol.ngp.common.mc.MessageChannelKeepAliveFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(ChainConfigurator.class);
    private final IoSession session;

    public ChainConfigurator(IoSession session) {
        this.session = session;
    }

    protected void replaceMarker(String name, IoFilter filter) {
        IoFilterChain.Entry entry = this.session.getFilterChain().getEntry(String.valueOf(name) + ".marker");
        if (entry == null) {
            throw new IllegalStateException(String.format("Filter with name '%s.marker' is missing", name));
        }
        entry.addAfter(name, filter);
        entry.remove();
    }

    public void startStreamCompression(int compressionLevel, boolean startInactive) {
        logger.info("Starting stream compression: {} (startInactive: {})", (Object)compressionLevel, (Object)startInactive);
        if (startInactive) {
            this.session.setAttribute((Object)CompressionFilter.DISABLE_COMPRESSION_ONCE, (Object)Boolean.TRUE);
        }
        this.replaceMarker("streamCompression", (IoFilter)new CompressionFilter(compressionLevel));
    }

    public void startKeepAlive(int pingFrequency, int timeout) {
        int pingInterval = (int)Math.ceil((double)timeout / (double)pingFrequency);
        logger.info("Starting keep alive - frequency: {}, timeout: {} seconds, ping interval: {} seconds", new Object[]{pingFrequency, timeout, pingInterval});
        this.replaceMarker("keepalive", (IoFilter)new KeepAliveFilter((KeepAliveMessageFactory)new MessageChannelKeepAliveFactory(), IdleStatus.READER_IDLE, KeepAliveRequestTimeoutHandler.CLOSE, pingInterval, timeout));
    }

    public void startSsl(boolean startInactive, boolean clientMode) throws Exception {
        logger.info("Starting SSL (startInactive: {})", (Object)startInactive);
        ProtocolConfiguration configuration = ProtocolConfiguration.fromSession(this.session);
        SslContextFactory sslFactory = configuration.getSslContextFactory();
        SSLContext sslContext = sslFactory.newInstance();
        if (startInactive) {
            this.session.setAttribute((Object)SslFilter.DISABLE_ENCRYPTION_ONCE, (Object)Boolean.TRUE);
        }
        SslFilter filter = new SslFilter(sslContext);
        filter.setUseClientMode(clientMode);
        filter.setWantClientAuth(false);
        filter.setNeedClientAuth(false);
        if (logger.isDebugEnabled()) {
            logger.debug("Enabled protocols:");
            String[] stringArray = sslContext.getDefaultSSLParameters().getProtocols();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String protocol = stringArray[n2];
                logger.debug("\t" + protocol);
                ++n2;
            }
            logger.debug("Enabled ciphers:");
            stringArray = sslContext.getDefaultSSLParameters().getCipherSuites();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String cipher = stringArray[n2];
                logger.debug("\t" + cipher);
                ++n2;
            }
        }
        this.replaceMarker("ssl", (IoFilter)filter);
    }
}

