/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.logging.LogLevel;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.util.NoopFilter;
import org.eclipse.scada.protocol.common.IoLoggerFilterChainBuilder;
import org.eclipse.scada.protocol.common.StatisticsFilter;
import org.eclipse.scada.protocol.ngp.common.mc.MessageChannelCodecFilter;
import org.eclipse.scada.protocol.ngp.common.mc.MessageChannelFilter;
import org.eclipse.scada.protocol.ngp.common.mc.frame.FrameDecoder;
import org.eclipse.scada.protocol.ngp.common.mc.frame.FrameEncoder;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChainBuilder
implements IoLoggerFilterChainBuilder {
    private static AtomicLong THREAD_COUNTER = new AtomicLong();
    private String loggerName;
    private final List<Entry> filters = new LinkedList<Entry>();

    public FilterChainBuilder(final boolean clientMode) {
        if (!Boolean.getBoolean("org.eclipse.scada.protocol.ngp.common.disableStats")) {
            this.filters.add(new Entry("core.stats", (IoFilter)new StatisticsFilter()));
        }
        this.filters.add(new Entry("logger.raw", new LoggerFilterFactory("raw")));
        this.filters.add(new Entry("ssl"));
        this.filters.add(new Entry("streamCompression"));
        this.filters.add(new Entry("logger", new LoggerFilterFactory("pre")));
        this.filters.add(new Entry("sync", (IoFilter)new ExecutorFilter(Integer.getInteger("org.eclipse.scada.protocol.ngp.common.coreSessionThreads", 0).intValue(), Integer.getInteger("org.eclipse.scada.protocol.ngp.common.maxSessionThreads", 1).intValue(), 1L, TimeUnit.MINUTES, (ThreadFactory)new NamedThreadFactory("org.eclipse.scada.protocol.ngp.common.FilterChainSync", false, true, THREAD_COUNTER), new IoEventType[]{IoEventType.WRITE})));
        this.filters.add(new Entry("frameCodec", (IoFilter)new ProtocolCodecFilter((ProtocolEncoder)new FrameEncoder(), (ProtocolDecoder)new FrameDecoder())));
        this.filters.add(new Entry("keepalive"));
        this.filters.add(new Entry("messageChannelCodec", (IoFilter)new MessageChannelCodecFilter()));
        this.filters.add(new Entry("messageChannel", new IoFilterFactoryAdapter(){

            @Override
            public IoFilter create() {
                return new MessageChannelFilter(clientMode);
            }
        }));
    }

    public void dispose() {
        for (Entry entry : this.filters) {
            try {
                entry.factory.dispose();
            }
            catch (Exception exception) {}
        }
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void buildFilterChain(IoFilterChain chain) {
        for (Entry entry : this.filters) {
            IoFilter filter = entry.getFactory().create();
            if (filter == null) continue;
            chain.addLast(entry.getName(), filter);
        }
    }

    private static class Entry {
        private final String name;
        private final IoFilterFactory factory;

        public Entry(String name) {
            this(String.valueOf(name) + ".marker", new MarkerFactory());
        }

        public Entry(String name, IoFilterFactory factory) {
            this.name = name;
            this.factory = factory;
        }

        public Entry(String name, IoFilter filter) {
            this(name, new StaticIoFilterFactory(filter));
        }

        public IoFilterFactory getFactory() {
            return this.factory;
        }

        public String getName() {
            return this.name;
        }
    }

    private static interface IoFilterFactory {
        public IoFilter create();

        public void dispose() throws Exception;
    }

    private static abstract class IoFilterFactoryAdapter
    implements IoFilterFactory {
        private IoFilterFactoryAdapter() {
        }

        @Override
        public void dispose() {
        }
    }

    private final class LoggerFilterFactory
    extends IoFilterFactoryAdapter {
        private final String suffix;

        public LoggerFilterFactory(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public IoFilter create() {
            if (FilterChainBuilder.this.loggerName != null && Boolean.getBoolean("org.eclipse.scada.protocol.ngp.common.logger")) {
                return new LoggingFilterExtension(this.suffix != null ? String.valueOf(FilterChainBuilder.this.loggerName) + "." + this.suffix : FilterChainBuilder.this.loggerName);
            }
            return null;
        }
    }

    private static class LoggingFilterExtension
    extends LoggingFilter {
        private final Logger logger;
        private final LogLevel filterWriteLevel = LogLevel.INFO;
        private final LogLevel filterCloseLevel = LogLevel.INFO;

        private LoggingFilterExtension(String name) {
            super(name);
            this.logger = LoggerFactory.getLogger((String)name);
        }

        protected void log(LogLevel level, String message, Object ... args) {
            switch (level) {
                case DEBUG: {
                    this.logger.debug(message, args);
                    break;
                }
                case INFO: {
                    this.logger.info(message, args);
                    break;
                }
                case WARN: {
                    this.logger.warn(message, args);
                    break;
                }
                case ERROR: {
                    this.logger.error(message, args);
                    break;
                }
                case TRACE: {
                    this.logger.trace(message, args);
                    break;
                }
            }
        }

        public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
            this.log(this.filterWriteLevel, "WRITE: {}", writeRequest.getMessage());
            nextFilter.filterWrite(session, writeRequest);
        }

        public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
            this.log(this.filterCloseLevel, "CLOSE", new Object[0]);
            nextFilter.filterClose(session);
        }
    }

    private static class MarkerFactory
    extends IoFilterFactoryAdapter {
        private MarkerFactory() {
        }

        @Override
        public IoFilter create() {
            return new NoopFilter();
        }
    }

    private static class StaticIoFilterFactory
    implements IoFilterFactory {
        private final IoFilter filter;

        public StaticIoFilterFactory(IoFilter filter) {
            this.filter = filter;
        }

        @Override
        public IoFilter create() {
            return this.filter;
        }

        @Override
        public void dispose() throws Exception {
            this.filter.destroy();
        }
    }
}

