/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.utils.password;

import java.util.List;
import org.eclipse.scada.sec.utils.password.DigestValidator;
import org.eclipse.scada.sec.utils.password.HexCodec;
import org.eclipse.scada.sec.utils.password.PasswordEncoder;
import org.eclipse.scada.sec.utils.password.PasswordEncoding;
import org.eclipse.scada.sec.utils.password.PasswordValidator;
import org.eclipse.scada.sec.utils.password.PlainValidator;

public enum PasswordType {
    PLAIN{

        @Override
        public PasswordEncoding getEncoding() throws Exception {
            return PasswordEncoding.PLAIN;
        }

        @Override
        public PasswordValidator createValdiator() {
            return new PlainValidator(false);
        }

        @Override
        public PasswordEncoder createEncoder() throws Exception {
            return this.getEncoding().getEncoder("UTF-8", new HexCodec());
        }
    }
    ,
    PLAIN_IGNORE_CASE{

        @Override
        public PasswordEncoding getEncoding() throws Exception {
            return PasswordEncoding.PLAIN;
        }

        @Override
        public PasswordValidator createValdiator() {
            return new PlainValidator(true);
        }

        @Override
        public PasswordEncoder createEncoder() throws Exception {
            return this.getEncoding().getEncoder("UTF-8", new HexCodec());
        }
    }
    ,
    MD5_HEX{

        @Override
        public PasswordEncoding getEncoding() throws Exception {
            return PasswordEncoding.MD5;
        }

        @Override
        public PasswordValidator createValdiator() {
            return new DigestValidator(PasswordEncoding.MD5, "UTF-8", new HexCodec());
        }

        @Override
        public PasswordEncoder createEncoder() throws Exception {
            return this.getEncoding().getEncoder("UTF-8", new HexCodec());
        }
    }
    ,
    SHA1_HEX{

        @Override
        public PasswordEncoding getEncoding() throws Exception {
            return PasswordEncoding.SHA1;
        }

        @Override
        public PasswordValidator createValdiator() {
            return new DigestValidator(PasswordEncoding.SHA1, "UTF-8", new HexCodec());
        }

        @Override
        public PasswordEncoder createEncoder() throws Exception {
            return this.getEncoding().getEncoder("UTF-8", new HexCodec());
        }
    };


    private PasswordType() {
    }

    public abstract PasswordEncoding getEncoding() throws Exception;

    public abstract PasswordValidator createValdiator();

    public abstract PasswordEncoder createEncoder() throws Exception;

    public List<PasswordEncoding> getSupportedInputEncodings() {
        return this.createValdiator().getSupportedInputEncodings();
    }

    /* synthetic */ PasswordType(String string, int n, PasswordType passwordType) {
        this();
    }
}

