/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.connection.provider.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.AbstractConnectionManager;
import org.eclipse.scada.core.connection.provider.AbstractConnectionService;
import org.eclipse.scada.hd.client.Connection;
import org.eclipse.scada.hd.connection.provider.ConnectionService;
import org.eclipse.scada.hd.connection.provider.ConnectionServiceImpl;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager
extends AbstractConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionManager.class);
    private static final Set<String> interfaces;

    static {
        HashSet<String> create = new HashSet<String>();
        create.add(ConnectionService.class.getName());
        interfaces = Collections.unmodifiableSet(create);
    }

    public ConnectionManager(BundleContext context, String connectionId, ConnectionInformation connectionInformation, Integer autoReconnectDelay, boolean initialOpen) {
        super(context, connectionInformation, connectionId, autoReconnectDelay, initialOpen);
    }

    protected AbstractConnectionService createConnection() {
        logger.debug("Create new HD connection: {}", (Object)this.getConnectionInformation());
        Connection connection = (Connection)this.getFactory().getDriverInformation(this.getConnectionInformation()).create(this.getConnectionInformation());
        if (connection == null) {
            logger.warn("Failed to create new HD connection: {}", (Object)this.getConnectionInformation());
            return null;
        }
        return new ConnectionServiceImpl(connection, this.getAutoReconnectDelay());
    }

    protected Set<String> getInterfaces() {
        return interfaces;
    }
}

