/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.pool;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.utils.osgi.pool.ObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllObjectPoolServiceTracker<S> {
    private static final Logger logger = LoggerFactory.getLogger(AllObjectPoolServiceTracker.class);
    private final ObjectPoolTracker<S> poolTracker;
    private final ObjectPoolTracker.ObjectPoolServiceListener<S> poolListener;
    private final Map<ObjectPool<S>, PoolHandler> poolMap = new HashMap<ObjectPool<S>, PoolHandler>();
    private final ObjectPoolListener<S> serviceListener;

    public AllObjectPoolServiceTracker(ObjectPoolTracker<S> poolTracker, ObjectPoolListener<S> listener) {
        this.serviceListener = listener;
        this.poolTracker = poolTracker;
        this.poolListener = new ObjectPoolTracker.ObjectPoolServiceListener<S>(){

            @Override
            public void poolRemoved(ObjectPool<S> objectPool) {
                AllObjectPoolServiceTracker.this.handlePoolRemove(objectPool);
            }

            @Override
            public void poolModified(ObjectPool<S> objectPool, int newPriority) {
                AllObjectPoolServiceTracker.this.handlePoolModified(objectPool, newPriority);
            }

            @Override
            public void poolAdded(ObjectPool<S> objectPool, int priority) {
                AllObjectPoolServiceTracker.this.handlePoolAdd(objectPool, priority);
            }
        };
    }

    protected void handleServiceAdded(S service, Dictionary<?, ?> properties) {
        logger.debug("Service added {} -> {}", new Object[]{service, properties});
        this.serviceListener.serviceAdded(service, properties);
    }

    protected void handleServiceModified(S service, Dictionary<?, ?> properties) {
        this.serviceListener.serviceModified(service, properties);
    }

    protected void handleServiceRemoved(S service, Dictionary<?, ?> properties) {
        this.serviceListener.serviceRemoved(service, properties);
    }

    protected synchronized void handlePoolAdd(ObjectPool<S> objectPool, int priority) {
        this.poolMap.put(objectPool, new PoolHandler(objectPool));
    }

    protected synchronized void handlePoolModified(ObjectPool<S> objectPool, int newPriority) {
    }

    protected synchronized void handlePoolRemove(ObjectPool<S> objectPool) {
        PoolHandler handler = this.poolMap.get(objectPool);
        if (handler != null) {
            handler.dispose();
        }
    }

    public void open() {
        this.poolTracker.addListener(this.poolListener);
    }

    public void close() {
        this.poolTracker.removeListener(this.poolListener);
    }

    protected class PoolHandler
    implements ObjectPoolListener<S> {
        private final ObjectPool<S> pool;
        private final Map<S, Dictionary<?, ?>> services = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PoolHandler(ObjectPool<S> pool) {
            this.pool = pool;
            PoolHandler poolHandler = this;
            synchronized (poolHandler) {
                this.pool.addListener(this);
            }
        }

        public synchronized void dispose() {
            this.pool.removeListener(this);
            for (Map.Entry entry : this.services.entrySet()) {
                this.fireServiceRemoved(entry.getKey(), entry.getValue());
            }
            this.services.clear();
        }

        @Override
        public synchronized void serviceAdded(S service, Dictionary<?, ?> properties) {
            this.services.put(service, properties);
            this.fireServiceAdded(service, properties);
        }

        private void fireServiceAdded(S service, Dictionary<?, ?> properties) {
            AllObjectPoolServiceTracker.this.handleServiceAdded(service, properties);
        }

        @Override
        public synchronized void serviceModified(S service, Dictionary<?, ?> properties) {
            this.services.put(service, properties);
            this.fireServiceModified(service, properties);
        }

        private void fireServiceModified(S service, Dictionary<?, ?> properties) {
            AllObjectPoolServiceTracker.this.handleServiceModified(service, properties);
        }

        @Override
        public synchronized void serviceRemoved(S service, Dictionary<?, ?> properties) {
            Dictionary<?, ?> oldProperties = this.services.remove(service);
            if (oldProperties != null) {
                this.fireServiceRemoved(service, properties);
            }
        }

        private void fireServiceRemoved(S service, Dictionary<?, ?> properties) {
            AllObjectPoolServiceTracker.this.handleServiceRemoved(service, properties);
        }
    }
}

