/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.pool;

import java.util.Dictionary;
import org.eclipse.scada.utils.osgi.pool.AbstractObjectPoolServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPoolServiceTracker<S>
extends AbstractObjectPoolServiceTracker<S> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectPoolServiceTracker.class);
    private final ObjectPoolListener<S> clientListener;

    public ObjectPoolServiceTracker(ObjectPoolTracker<S> poolTracker, String serviceId, ObjectPoolListener<S> listener) {
        super(poolTracker, serviceId);
        this.clientListener = listener;
        logger.debug("new pool service tracker for {}", (Object)serviceId);
    }

    @Override
    protected void handleServiceAdded(S service, Dictionary<?, ?> properties) {
        this.fireServiceAdded(service, properties);
    }

    private void fireServiceAdded(S service, Dictionary<?, ?> properties) {
        this.clientListener.serviceAdded(service, properties);
    }

    @Override
    protected void handleServiceModified(S service, Dictionary<?, ?> properties) {
        this.fireServiceModified(service, properties);
    }

    private void fireServiceModified(S service, Dictionary<?, ?> properties) {
        this.clientListener.serviceModified(service, properties);
    }

    @Override
    protected void handleServiceRemoved(S service, Dictionary<?, ?> properties) {
        this.fireServiceRemoved(service, properties);
    }

    private void fireServiceRemoved(S service, Dictionary<?, ?> properties) {
        this.clientListener.serviceRemoved(service, properties);
    }
}

