/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.connection.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.core.client.connection.service.AbstractConnectionManager;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.sec.UserInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagedConnectionServiceFactory<ConnectionServiceType extends ConnectionService>
implements ConfigurationFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractManagedConnectionServiceFactory.class);
    public static final String CONNECTION_URI = "connection.uri";
    private final Map<String, AbstractConnectionManager<ConnectionServiceType>> connections = new HashMap<String, AbstractConnectionManager<ConnectionServiceType>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(UserInformation userInformation, String pid) {
        AbstractConnectionManager<ConnectionServiceType> connection;
        logger.info("Request to delete: {}", (Object)pid);
        AbstractManagedConnectionServiceFactory abstractManagedConnectionServiceFactory = this;
        synchronized (abstractManagedConnectionServiceFactory) {
            connection = this.connections.remove(pid);
        }
        if (connection != null) {
            connection.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(UserInformation userInformation, String pid, Map<String, String> properties) {
        logger.info("Update request: {} ({})", (Object)pid, properties);
        String uri = properties.get(CONNECTION_URI);
        if (uri == null) {
            throw new RuntimeException(String.format("'%s' is not set", CONNECTION_URI));
        }
        AbstractManagedConnectionServiceFactory abstractManagedConnectionServiceFactory = this;
        synchronized (abstractManagedConnectionServiceFactory) {
            this.delete(userInformation, pid);
            AbstractConnectionManager<ConnectionServiceType> newManager = this.createConnectionManager(pid, uri);
            if (newManager != null) {
                this.publishConnection(pid, newManager);
            }
        }
    }

    protected abstract AbstractConnectionManager<ConnectionServiceType> createConnectionManager(String var1, String var2);

    private void publishConnection(String pid, AbstractConnectionManager<ConnectionServiceType> manager) {
        this.connections.put(pid, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashMap<String, AbstractConnectionManager<ConnectionServiceType>> connections;
        AbstractManagedConnectionServiceFactory abstractManagedConnectionServiceFactory = this;
        synchronized (abstractManagedConnectionServiceFactory) {
            connections = new HashMap<String, AbstractConnectionManager<ConnectionServiceType>>(this.connections);
            this.connections.clear();
        }
        for (AbstractConnectionManager manager : connections.values()) {
            manager.dispose();
        }
    }
}

