/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GridAlignment implements Enumerator
{
    CENTER(0, "CENTER", "CENTER"),
    FILL(1, "FILL", "FILL"),
    BEGINNING(2, "BEGINNING", "BEGINNING"),
    END(3, "END", "END");

    public static final int CENTER_VALUE = 0;
    public static final int FILL_VALUE = 1;
    public static final int BEGINNING_VALUE = 2;
    public static final int END_VALUE = 3;
    private static final GridAlignment[] VALUES_ARRAY;
    public static final List<GridAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GridAlignment[]{CENTER, FILL, BEGINNING, END};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GridAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GridAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GridAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GridAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GridAlignment get(int value) {
        switch (value) {
            case 0: {
                return CENTER;
            }
            case 1: {
                return FILL;
            }
            case 2: {
                return BEGINNING;
            }
            case 3: {
                return END;
            }
        }
        return null;
    }

    private GridAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

