/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.base;

import org.eclipse.scada.net.base.LongRunningController;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.utils.exec.LongRunningListener;
import org.eclipse.scada.utils.exec.LongRunningState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongRunningOperation
implements org.eclipse.scada.utils.exec.LongRunningOperation {
    private static final Logger logger = LoggerFactory.getLogger(LongRunningOperation.class);
    private LongRunningController controller = null;
    private LongRunningListener listener = null;
    private long id = 0L;
    private LongRunningState longRunningState = LongRunningState.REQUESTED;
    private Throwable error = null;
    private Message reply = null;

    protected LongRunningOperation(LongRunningController controller, LongRunningListener listener) {
        this.controller = controller;
        this.listener = listener;
    }

    protected long getId() {
        return this.id;
    }

    private synchronized void stateChange(LongRunningState state, Message message, Throwable error) {
        logger.debug("LongRunningState change: {}", (Object)state.toString());
        this.longRunningState = state;
        this.reply = message;
        this.error = error;
        if (this.listener != null) {
            this.listener.stateChanged((org.eclipse.scada.utils.exec.LongRunningOperation)this, state, error);
        }
    }

    protected synchronized void fail(Throwable error) {
        this.stateChange(LongRunningState.FAILURE, null, error);
        this.notifyAll();
    }

    protected synchronized void granted(long id) {
        logger.debug("Granted: {}", (Object)id);
        this.id = id;
        this.stateChange(LongRunningState.RUNNING, null, null);
    }

    protected synchronized void result(Message message) {
        logger.debug("Result: {}", (Object)this.id);
        this.stateChange(LongRunningState.SUCCESS, message, null);
        this.notifyAll();
    }

    public synchronized boolean isComplete() {
        return this.longRunningState.equals((Object)LongRunningState.SUCCESS) || this.longRunningState.equals((Object)LongRunningState.FAILURE);
    }

    public Throwable getError() {
        return this.error;
    }

    public Message getReply() {
        return this.reply;
    }

    public LongRunningState getState() {
        return this.longRunningState;
    }

    public synchronized void waitForCompletion() throws InterruptedException {
        while (!this.isComplete()) {
            this.wait();
        }
    }

    public synchronized void waitForCompletion(int timeout) throws InterruptedException {
        while (!this.isComplete()) {
            this.wait(timeout);
        }
    }
}

