/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.base.data;

import org.eclipse.scada.net.base.data.Value;

public class IntegerValue
extends Value {
    private static final int VALUES = 100;
    private static final IntegerValue[] staticValues = new IntegerValue[100];
    public final int value;

    static {
        int i = 0;
        while (i < staticValues.length) {
            IntegerValue.staticValues[i] = new IntegerValue(i);
            ++i;
        }
    }

    public static IntegerValue valueOf(int value) {
        if (value >= 0 && value < 100) {
            return staticValues[value];
        }
        return new IntegerValue(value);
    }

    public IntegerValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerValue other = (IntegerValue)obj;
        return this.value == other.value;
    }
}

