/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.controller;

import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DisposeListener;
import org.eclipse.scada.chart.swt.render.AbstractPositionXRuler;
import org.eclipse.swt.graphics.Rectangle;

public class MouseHover
extends AbstractPositionXRuler
implements ChartMouseMoveListener {
    private final ChartRenderer chart;
    private final XAxis xAxis;
    private final Listener listener;
    private long position;
    private Rectangle clientRect;

    public MouseHover(ChartRenderer chart, XAxis xAxis, Listener listener) {
        super(xAxis);
        this.chart = chart;
        this.xAxis = xAxis;
        this.listener = listener;
        chart.addDisposeListener(new DisposeListener(){

            @Override
            public void onDispose() {
                MouseHover.this.dispose();
            }
        });
        chart.addMouseMoveListener(this);
        chart.addRenderer(this);
    }

    public void dispose() {
        this.chart.removeRenderer(this);
        this.chart.removeMouseMoveListener(this);
    }

    @Override
    public void onMouseMove(ChartMouseListener.MouseState state) {
        if (this.listener != null) {
            this.position = this.xAxis.translateToValue(this.clientRect.width, (float)(state.x - this.clientRect.x));
            this.listener.mouseMove(state, this.position);
            if (this.visible) {
                this.chart.redraw();
            }
        }
    }

    @Override
    public Long getPosition() {
        return this.position;
    }

    @Override
    public Rectangle resize(Rectangle clientRectangle) {
        this.clientRect = clientRectangle;
        return super.resize(clientRectangle);
    }

    public static interface Listener {
        public void mouseMove(ChartMouseListener.MouseState var1, long var2);
    }
}

