/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class Event
implements Cloneable,
Comparable<Event>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final EventComparator comparator = new EventComparator();
    private UUID id;
    private Date sourceTimestamp;
    private Date entryTimestamp;
    private final Map<String, Variant> attributes = new HashMap<String, Variant>();
    public static final Event NULL_EVENT = Event.create().id(new UUID(0L, 0L)).sourceTimestamp(new Date(0L)).entryTimestamp(new Date(0L)).build();

    private Event(Event event) {
        this.id = event.getId();
        this.sourceTimestamp = event.getSourceTimestamp();
        this.entryTimestamp = event.getEntryTimestamp();
        this.attributes.putAll(event.getAttributes());
    }

    private Event() {
    }

    public UUID getId() {
        return this.id;
    }

    public Date getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    public Date getEntryTimestamp() {
        return this.entryTimestamp;
    }

    public Map<String, Variant> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static EventBuilder create() {
        return new EventBuilder();
    }

    public Event clone() {
        return new Event(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Event {");
        sb.append("id: ");
        sb.append(this.id == null ? null : this.id.toString());
        sb.append(", sourceTimestamp: ");
        sb.append(this.sourceTimestamp == null ? null : this.sourceTimestamp.toString());
        sb.append(", entryTimestamp: ");
        sb.append(this.entryTimestamp == null ? null : this.entryTimestamp.toString());
        for (Map.Entry<String, Variant> entry : this.attributes.entrySet()) {
            sb.append(", " + entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue() == null ? null : entry.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int compareTo(Event o) {
        return comparator.compare(this, o);
    }

    public Variant getField(Fields field) {
        if (field == null) {
            return null;
        }
        return this.attributes.get(field.getName());
    }

    public void setField(Fields field, Variant value) {
        if (field == null || value == null) {
            return;
        }
        this.attributes.put(field.getName(), value);
    }

    /* synthetic */ Event(Event event, Event event2) {
        this();
    }

    /* synthetic */ Event(Event event, Event event2, Event event3) {
        this(event);
    }

    public static class EventBuilder {
        private final Event event = new Event(null, null);
        private boolean allowOverrideAttributes = true;

        private EventBuilder() {
        }

        public EventBuilder event(Event event) {
            this.event.id = event.getId();
            this.event.sourceTimestamp = event.getSourceTimestamp();
            this.event.entryTimestamp = event.getEntryTimestamp();
            this.event.attributes.putAll(event.getAttributes());
            return this;
        }

        public EventBuilder id(UUID id) {
            this.event.id = id;
            return this;
        }

        public EventBuilder sourceTimestamp(Date sourceTimestamp) {
            this.event.sourceTimestamp = sourceTimestamp;
            return this;
        }

        public EventBuilder entryTimestamp(Date entryTimestamp) {
            this.event.entryTimestamp = entryTimestamp;
            return this;
        }

        public EventBuilder attributes(Map<String, Variant> attributes) {
            if (attributes == null) {
                return this;
            }
            if (this.allowOverrideAttributes) {
                for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
                    if (entry.getValue() == null || entry.getKey() == null) continue;
                    this.event.attributes.put(entry.getKey(), entry.getValue());
                }
                this.event.attributes.putAll(attributes);
            } else {
                for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
                    if (entry.getValue() == null || entry.getKey() == null) continue;
                    this.attribute(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public EventBuilder attribute(String key, Variant value) {
            if (key == null || value == null) {
                return this;
            }
            if (this.allowOverrideAttributes || !this.event.attributes.containsKey(key)) {
                this.event.attributes.put(key, value);
            }
            return this;
        }

        public EventBuilder attribute(Fields key, Variant value) {
            if (value != null) {
                this.attribute(key.getName(), value);
            }
            return this;
        }

        public EventBuilder attribute(String key, Object value) {
            if (value != null) {
                this.attribute(key, Variant.valueOf((Object)value));
            }
            return this;
        }

        public EventBuilder attribute(Fields key, Object value) {
            if (value != null) {
                this.attribute(key.getName(), Variant.valueOf((Object)value));
            }
            return this;
        }

        public boolean hasAttribute(String key) {
            return this.event.getAttributes().containsKey(key);
        }

        public boolean hasAttribute(Fields key) {
            return this.event.getAttributes().containsKey(key.getName());
        }

        public void setAllowOverrideAttributes(boolean allowOverrideAttributes) {
            this.allowOverrideAttributes = allowOverrideAttributes;
        }

        public Event build() {
            return new Event(this.event, null, null);
        }
    }

    public static class EventComparator
    implements Comparator<Event> {
        @Override
        public int compare(Event o1, Event o2) {
            int s = o1.getSourceTimestamp().compareTo(o2.getSourceTimestamp());
            if (s == 0) {
                int e = o1.getEntryTimestamp().compareTo(o2.getEntryTimestamp());
                if (e == 0) {
                    return o1.getId().compareTo(o2.getId());
                }
                return e;
            }
            return s;
        }
    }

    public static enum Fields {
        MONITOR_TYPE("monitorType", String.class),
        EVENT_TYPE("eventType", String.class),
        VALUE("value", Variant.class),
        MESSAGE("message", String.class),
        MESSAGE_CODE("messageSource", String.class),
        PRIORITY("priority", Integer.class),
        SEVERITY("severity", String.class),
        SOURCE("source", String.class),
        ACTOR_NAME("actorName", String.class),
        ACTOR_TYPE("actorType", String.class),
        HIVE("hive", String.class),
        ITEM("item", String.class),
        COMPONENT("component", String.class),
        SYSTEM("system", String.class),
        LOCATION("location", String.class),
        COMMENT("comment", String.class);

        private final Class<? extends Object> clazz;
        private final String name;

        private Fields(String name, Class<? extends Object> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public Class<? extends Object> getType() {
            return this.clazz;
        }

        public String getName() {
            return this.name;
        }

        public boolean contains(String name) {
            return Fields.byField(name) != null;
        }

        public static Fields byField(String name) {
            Fields[] fieldsArray = Fields.values();
            int n = fieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fields field = fieldsArray[n2];
                if (field.getName().equals(name)) {
                    return field;
                }
                ++n2;
            }
            return null;
        }
    }
}

