/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.filter.internal;

import java.beans.PropertyEditor;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.filter.EventMatcher;
import org.eclipse.scada.ae.filter.internal.Messages;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.utils.filter.Assertion;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterAssertion;
import org.eclipse.scada.utils.filter.FilterExpression;
import org.eclipse.scada.utils.filter.FilterParser;
import org.eclipse.scada.utils.filter.Operator;
import org.eclipse.scada.utils.lang.Apply;
import org.eclipse.scada.utils.propertyeditors.DateEditor;
import org.eclipse.scada.utils.propertyeditors.IntegerEditor;
import org.eclipse.scada.utils.propertyeditors.PropertyEditorRegistry;
import org.eclipse.scada.utils.propertyeditors.StringEditor;
import org.eclipse.scada.utils.propertyeditors.UUIDEditor;
import org.eclipse.scada.utils.str.StringHelper;

public class EventMatcherImpl
implements EventMatcher {
    private static final DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    private static PropertyEditorRegistry propertyEditorRegistry = new PropertyEditorRegistry();
    private final Filter filter;

    static {
        propertyEditorRegistry.registerCustomEditor(String.class, (PropertyEditor)new StringEditor());
        propertyEditorRegistry.registerCustomEditor(Integer.class, (PropertyEditor)new IntegerEditor());
        propertyEditorRegistry.registerCustomEditor(java.util.Date.class, (PropertyEditor)new DateEditor());
        propertyEditorRegistry.registerCustomEditor(Date.class, (PropertyEditor)new DateEditor());
        propertyEditorRegistry.registerCustomEditor(Calendar.class, (PropertyEditor)new DateEditor());
        propertyEditorRegistry.registerCustomEditor(UUID.class, (PropertyEditor)new UUIDEditor());
        propertyEditorRegistry.registerCustomEditor(Variant.class, (PropertyEditor)new VariantEditor());
    }

    public EventMatcherImpl(String filter) {
        this.filter = new FilterParser(filter).getFilter();
    }

    public EventMatcherImpl(Filter filter) {
        this.filter = filter;
    }

    @Override
    public boolean matches(Event event) {
        return EventMatcherImpl.matches(this.filter, event);
    }

    private static boolean matches(Filter filter, Event event) {
        if (filter.isEmpty()) {
            return true;
        }
        if (filter.isAssertion()) {
            return EventMatcherImpl.matches((FilterAssertion)filter, event);
        }
        if (filter.isExpression()) {
            return EventMatcherImpl.matches((FilterExpression)filter, event);
        }
        return false;
    }

    private static boolean matches(FilterExpression expression, Event event) {
        if (expression.getOperator() == Operator.AND) {
            boolean result = true;
            for (Filter subFilter : expression.getFilterSet()) {
                boolean bl = result = result && EventMatcherImpl.matches(subFilter, event);
            }
            return result;
        }
        if (expression.getOperator() == Operator.OR) {
            boolean result = false;
            for (Filter subFilter : expression.getFilterSet()) {
                boolean bl = result = result || EventMatcherImpl.matches(subFilter, event);
            }
            return result;
        }
        if (expression.getOperator() == Operator.NOT) {
            boolean result = true;
            for (Filter subFilter : expression.getFilterSet()) {
                boolean bl = result = result && EventMatcherImpl.matches(subFilter, event);
            }
            return !result;
        }
        return false;
    }

    private static boolean matches(FilterAssertion assertion, Event event) {
        if ("id".equals(assertion.getAttribute())) {
            return EventMatcherImpl.compareId(assertion, event.getId());
        }
        if ("sourceTimestamp".equals(assertion.getAttribute())) {
            return EventMatcherImpl.compareTimestamp(assertion, event.getSourceTimestamp());
        }
        if ("entryTimestamp".equals(assertion.getAttribute())) {
            return EventMatcherImpl.compareTimestamp(assertion, event.getEntryTimestamp());
        }
        return EventMatcherImpl.compareVariant(assertion, (Variant)event.getAttributes().get(assertion.getAttribute()));
    }

    private static boolean compareId(FilterAssertion assertion, UUID left) {
        if (assertion.getAssertion() == Assertion.PRESENCE) {
            return left != null;
        }
        if (assertion.getValue() == null) {
            return false;
        }
        if (!(assertion.getValue() instanceof String || assertion.getValue() instanceof UUID || assertion.getValue() instanceof Collection)) {
            return false;
        }
        if (assertion.getAssertion() == Assertion.SUBSTRING) {
            return left.toString().matches(EventMatcherImpl.toRegEx((Collection)assertion.getValue()));
        }
        UUID right = UUID.fromString(assertion.getValue().toString());
        switch (assertion.getAssertion()) {
            case LESSTHAN: {
                return left.compareTo(right) == -1;
            }
            case LESSEQ: {
                return left.compareTo(right) == -1 || left.compareTo(right) == 0;
            }
            case EQUALITY: {
                return left.compareTo(right) == 0;
            }
            case GREATEREQ: {
                return left.compareTo(right) == 1 || left.compareTo(right) == 0;
            }
            case GREATERTHAN: {
                return left.compareTo(right) == 1;
            }
            case APPROXIMATE: {
                throw new IllegalArgumentException(Messages.getString("EventMatcherImpl.Error.ApproximateNotSupported"));
            }
        }
        return false;
    }

    private static boolean compareTimestamp(FilterAssertion assertion, java.util.Date left) {
        if (assertion.getAssertion() == Assertion.PRESENCE) {
            return left != null;
        }
        if (assertion.getValue() == null) {
            return false;
        }
        if (!(assertion.getValue() instanceof String || assertion.getValue() instanceof java.util.Date || assertion.getValue() instanceof Collection)) {
            return false;
        }
        if (assertion.getAssertion() == Assertion.SUBSTRING) {
            return isoDateFormat.format(left).matches(EventMatcherImpl.toRegEx((Collection)assertion.getValue()));
        }
        java.util.Date right = null;
        if (assertion.getValue() instanceof String) {
            PropertyEditor pe = propertyEditorRegistry.findCustomEditor(java.util.Date.class);
            pe.setAsText((String)assertion.getValue());
            right = (java.util.Date)pe.getValue();
        } else if (assertion.getValue() instanceof java.util.Date) {
            right = (java.util.Date)assertion.getValue();
        } else {
            throw new IllegalArgumentException(Messages.getString("EventMatcherImpl.Error.ValueTypeNotSupported"));
        }
        switch (assertion.getAssertion()) {
            case LESSTHAN: {
                return left.compareTo(right) == -1;
            }
            case LESSEQ: {
                return left.compareTo(right) == -1 || left.compareTo(right) == 0;
            }
            case EQUALITY: {
                return left.compareTo(right) == 0;
            }
            case GREATEREQ: {
                return left.compareTo(right) == 1 || left.compareTo(right) == 0;
            }
            case GREATERTHAN: {
                return left.compareTo(right) == 1;
            }
            case APPROXIMATE: {
                throw new IllegalArgumentException(Messages.getString("EventMatcherImpl.Error.ApproximateNotSupported"));
            }
        }
        return false;
    }

    private static boolean compareVariant(FilterAssertion assertion, Variant left) {
        if (assertion.getAssertion() == Assertion.PRESENCE) {
            return left != null;
        }
        if (assertion.getValue() == null) {
            return false;
        }
        if (left == null) {
            return false;
        }
        if (!(assertion.getValue() instanceof String || assertion.getValue() instanceof java.util.Date || assertion.getValue() instanceof Collection)) {
            return false;
        }
        if (assertion.getAssertion() == Assertion.SUBSTRING) {
            return left.asString("").matches(EventMatcherImpl.toRegEx((Collection)assertion.getValue()));
        }
        Variant right = null;
        if (assertion.getValue() instanceof String) {
            PropertyEditor pe = propertyEditorRegistry.findCustomEditor(Variant.class);
            pe.setAsText((String)assertion.getValue());
            right = (Variant)pe.getValue();
        } else if (assertion.getValue() instanceof Variant) {
            right = (Variant)assertion.getValue();
        } else {
            throw new IllegalArgumentException(Messages.getString("EventMatcherImpl.Error.ValueTypeNotSupported"));
        }
        switch (assertion.getAssertion()) {
            case LESSTHAN: {
                return left.compareTo(right) == -1;
            }
            case LESSEQ: {
                return left.compareTo(right) == -1 || left.compareTo(right) == 0;
            }
            case EQUALITY: {
                return left.compareTo(right) == 0;
            }
            case GREATEREQ: {
                return left.compareTo(right) == 1 || left.compareTo(right) == 0;
            }
            case GREATERTHAN: {
                return left.compareTo(right) == 1;
            }
            case APPROXIMATE: {
                throw new IllegalArgumentException(Messages.getString("EventMatcherImpl.Error.ApproximateNotSupported"));
            }
        }
        return false;
    }

    private static String toRegEx(Collection<String> parts) {
        return StringHelper.join(parts, (String)".*", (Apply)new Apply<String>(){

            public String apply(String parameter) {
                return Pattern.quote(parameter);
            }
        });
    }
}

